/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.remoting.ConnectorResource;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.SecurityActions;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Sequence;
import org.xnio.sasl.SaslQop;
import org.xnio.sasl.SaslStrength;

public class ConnectorAdd
extends AbstractAddStepHandler {
    static final ConnectorAdd INSTANCE = new ConnectorAdd();

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        ConnectorResource.SOCKET_BINDING.validateAndSet(operation, model);
        ConnectorResource.AUTHENTICATION_PROVIDER.validateAndSet(operation, model);
        if (operation.hasDefined("security-realm")) {
            model.get("security-realm").set(operation.get("security-realm").asString());
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String connectorName = address.getLastElement().getValue();
        ServiceName tmpDirPath = ServiceName.JBOSS.append(new String[]{"server", "path", "jboss.controller.temp.dir"});
        ServiceName securityRealm = model.hasDefined("security-realm") ? SecurityRealmService.BASE_SERVICE_NAME.append(new String[]{model.require("security-realm").asString()}) : null;
        RemotingServices.installSecurityServices(context.getServiceTarget(), connectorName, securityRealm, null, tmpDirPath, verificationHandler, newControllers);
        this.launchServices(context, address, connectorName, model, verificationHandler, newControllers);
    }

    void launchServices(OperationContext context, PathAddress pathAddress, String connectorName, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        OptionMap optionMap;
        ServiceTarget target = context.getServiceTarget();
        ServiceName socketBindingName = SocketBinding.JBOSS_BINDING_NAME.append(new String[]{ConnectorResource.SOCKET_BINDING.resolveModelAttribute(context, model).asString()});
        Resource resource = this.findResource(context.getRootResource(), pathAddress);
        Set entries = resource.getChildren("property");
        if (entries.size() > 0) {
            OptionMap.Builder builder = OptionMap.builder();
            ClassLoader loader = SecurityActions.getClassLoader(((Object)((Object)this)).getClass());
            for (Resource.ResourceEntry entry : entries) {
                Option option = Option.fromString((String)entry.getName(), (ClassLoader)loader);
                builder.set(option, option.parseValue(entry.getModel().get("value").asString(), loader));
            }
            optionMap = builder.getMap();
        } else {
            optionMap = OptionMap.EMPTY;
        }
        RemotingServices.installConnectorServicesForSocketBinding(target, RemotingServices.SUBSYSTEM_ENDPOINT, connectorName, socketBindingName, optionMap, verificationHandler, newControllers);
    }

    private Resource findResource(Resource rootResource, PathAddress address) {
        Resource resource = rootResource;
        ListIterator iterator = address.iterator();
        while (iterator.hasNext()) {
            resource = resource.getChild((PathElement)iterator.next());
        }
        return resource;
    }

    static OptionMap createOptionMap(ModelNode parameters) {
        OptionMap.Builder builder = OptionMap.builder();
        if (parameters.hasDefined("sasl")) {
            ModelNode sasl = parameters.require("sasl");
            builder.set(Options.SASL_SERVER_AUTH, sasl.get("server-auth").asBoolean());
            builder.set(Options.SASL_STRENGTH, (Object)SaslStrength.valueOf((String)sasl.get("strength").asString()));
            builder.set(Options.SASL_QOP, (Object)Sequence.of(ConnectorAdd.asQopSet(sasl.get("qop"))));
            builder.set(Options.SASL_MECHANISMS, (Object)Sequence.of(ConnectorAdd.asStringSet(sasl.get("include-mechanisms"))));
            if (sasl.hasDefined("policy")) {
                ModelNode policy = sasl.require("policy");
                builder.set(Options.SASL_POLICY_FORWARD_SECRECY, policy.get("forward-secrecy").asBoolean());
                builder.set(Options.SASL_POLICY_NOACTIVE, policy.get("no-active").asBoolean());
                builder.set(Options.SASL_POLICY_NOANONYMOUS, policy.get("no-anonymous").asBoolean());
                builder.set(Options.SASL_POLICY_NODICTIONARY, policy.get("no-dictionary").asBoolean());
                builder.set(Options.SASL_POLICY_NOPLAINTEXT, policy.get("no-plain-text").asBoolean());
                builder.set(Options.SASL_POLICY_PASS_CREDENTIALS, policy.get("pass-credentials").asBoolean());
            }
        }
        return builder.getMap();
    }

    static Collection<String> asStringSet(ModelNode node) {
        HashSet<String> set = new HashSet<String>();
        for (ModelNode element : node.asList()) {
            set.add(element.asString());
        }
        return set;
    }

    static Collection<SaslQop> asQopSet(ModelNode node) {
        HashSet<SaslQop> set = new HashSet<SaslQop>();
        for (ModelNode element : node.asList()) {
            set.add(SaslQop.valueOf((String)element.asString()));
        }
        return set;
    }
}

