/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.io.Closeable;
import java.util.concurrent.Executor;
import org.jboss.as.remoting.XnioUtil;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.Registration;
import org.jboss.remoting3.Remoting;
import org.jboss.remoting3.remote.RemoteConnectionProviderFactory;
import org.jboss.remoting3.spi.ConnectionProviderFactory;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;

public final class EndpointService
implements Service<Endpoint> {
    private Endpoint endpoint;
    private OptionMap optionMap;
    private Registration providerRegistration;
    private final InjectedValue<Executor> executor = new InjectedValue();

    public synchronized void setOptionMap(OptionMap optionMap) {
        this.optionMap = optionMap;
    }

    public synchronized void start(StartContext context) throws StartException {
        try {
            this.endpoint = Remoting.createEndpoint((String)"endpoint", (Executor)((Executor)this.executor.getValue()), (OptionMap)this.optionMap);
            Xnio xnio = XnioUtil.getXnio();
            this.providerRegistration = this.endpoint.addConnectionProvider("remote", (ConnectionProviderFactory)new RemoteConnectionProviderFactory(xnio), OptionMap.create((Option)Options.SSL_ENABLED, (Object)false));
        }
        catch (Exception e) {
            throw new StartException("Failed to start service", (Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        IoUtils.safeClose((Closeable)this.providerRegistration);
        IoUtils.safeClose((Closeable)this.endpoint);
    }

    public synchronized Endpoint getValue() throws IllegalStateException {
        Endpoint endpoint = this.endpoint;
        if (endpoint == null) {
            throw new IllegalStateException();
        }
        return endpoint;
    }

    Injector<Executor> getExecutorInjector() {
        return this.executor;
    }
}

