/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.as.remoting.Attribute;
import org.jboss.as.remoting.Element;
import org.jboss.as.remoting.PolicyElement;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Options;
import org.jboss.xnio.SaslQop;
import org.jboss.xnio.SaslStrength;
import org.jboss.xnio.Sequence;

public final class SaslElement
extends AbstractModelElement<SaslElement> {
    private static final long serialVersionUID = -7152729794181116303L;
    private PolicyElement policy;
    private String[] includeMechanisms;
    private SaslQop[] qop;
    private SaslStrength[] strength;
    private Boolean reuseSession;
    private Boolean serverAuth;
    private Map<String, String> properties;

    protected Class<SaslElement> getElementClass() {
        return SaslElement.class;
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        if (this.includeMechanisms != null) {
            streamWriter.writeEmptyElement("include-mechanisms");
            streamWriter.writeAttribute("value", this.includeMechanisms);
        }
        if (this.qop != null) {
            streamWriter.writeEmptyElement("qop");
            streamWriter.writeAttribute("value", this.qop.toString().toLowerCase(Locale.ENGLISH));
        }
        if (this.strength != null) {
            streamWriter.writeEmptyElement("strength");
            streamWriter.writeAttribute("value", this.strength.toString().toLowerCase(Locale.ENGLISH));
        }
        if (this.reuseSession != null) {
            streamWriter.writeEmptyElement("reuse-session");
            streamWriter.writeAttribute("value", this.reuseSession.toString());
        }
        if (this.serverAuth != null) {
            streamWriter.writeEmptyElement("server-auth");
            streamWriter.writeAttribute("value", this.serverAuth.toString());
        }
        if (this.policy != null) {
            streamWriter.writeStartElement("policy");
            this.policy.writeContent(streamWriter);
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            streamWriter.writeStartElement(Element.PROPERTIES.getLocalName());
            for (String key : this.properties.keySet()) {
                streamWriter.writeEmptyElement(Element.PROPERTY.getLocalName());
                streamWriter.writeAttribute(Attribute.NAME.getLocalName(), key);
                streamWriter.writeAttribute(Attribute.VALUE.getLocalName(), this.properties.get(key));
            }
            streamWriter.writeEndElement();
        }
        streamWriter.writeEndElement();
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public PolicyElement getPolicy() {
        return this.policy;
    }

    void setPolicy(PolicyElement policy) {
        this.policy = policy;
    }

    public String[] getIncludeMechanisms() {
        return this.includeMechanisms;
    }

    void setIncludeMechanisms(String[] includeMechanisms) {
        this.includeMechanisms = includeMechanisms;
    }

    public SaslQop[] getQop() {
        return this.qop;
    }

    void setQop(SaslQop[] qop) {
        this.qop = qop;
    }

    public SaslStrength[] getStrength() {
        return this.strength;
    }

    void setStrength(SaslStrength[] strength) {
        this.strength = strength;
    }

    public Boolean getReuseSession() {
        return this.reuseSession;
    }

    void setReuseSession(Boolean reuseSession) {
        this.reuseSession = reuseSession;
    }

    public Boolean getServerAuth() {
        return this.serverAuth;
    }

    void setServerAuth(Boolean serverAuth) {
        this.serverAuth = serverAuth;
    }

    public void applyTo(OptionMap.Builder builder) {
        if (this.policy != null) {
            this.policy.applyTo(builder);
        }
        if (this.includeMechanisms != null) {
            builder.set(Options.SASL_MECHANISMS, (Object)Sequence.of((Object[])this.includeMechanisms));
        }
        if (this.qop != null) {
            builder.set(Options.SASL_QOP, (Object)Sequence.of((Object[])this.qop));
        }
        if (this.strength != null) {
            // empty if block
        }
        if (this.reuseSession != null) {
            builder.set(Options.SASL_REUSE, (Object)this.reuseSession);
        }
        if (this.serverAuth != null) {
            builder.set(Options.SASL_SERVER_AUTH, (Object)this.serverAuth);
        }
    }
}

