/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.net.InetSocketAddress;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.UnknownURISchemeException;
import org.jboss.remoting3.security.ServerAuthenticationProvider;
import org.jboss.remoting3.spi.NetworkServerProvider;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.channels.ConnectedStreamChannel;

public final class ConnectorService
implements Service<ChannelListener<ConnectedStreamChannel<InetSocketAddress>>> {
    private final InjectedValue<Endpoint> endpointInjectedValue = new InjectedValue();
    private final InjectedValue<ServerAuthenticationProvider> authenticationProviderInjectedValue = new InjectedValue();
    private OptionMap optionMap;
    private ChannelListener<ConnectedStreamChannel<InetSocketAddress>> listener;

    public synchronized void start(StartContext context) throws StartException {
        NetworkServerProvider provider;
        Endpoint endpoint = (Endpoint)this.endpointInjectedValue.getValue();
        try {
            provider = (NetworkServerProvider)endpoint.getConnectionProviderInterface("remote", NetworkServerProvider.class);
        }
        catch (UnknownURISchemeException e) {
            throw new StartException((Throwable)e);
        }
        this.listener = provider.getServerListener(this.optionMap, (ServerAuthenticationProvider)this.authenticationProviderInjectedValue.getValue());
    }

    public synchronized void stop(StopContext context) {
        this.listener = null;
    }

    public synchronized ChannelListener<ConnectedStreamChannel<InetSocketAddress>> getValue() throws IllegalStateException {
        ChannelListener<ConnectedStreamChannel<InetSocketAddress>> listener = this.listener;
        if (listener == null) {
            throw new IllegalStateException();
        }
        return listener;
    }

    OptionMap getOptionMap() {
        return this.optionMap;
    }

    void setOptionMap(OptionMap optionMap) {
        this.optionMap = optionMap;
    }

    Injector<ServerAuthenticationProvider> getAuthenticationProviderInjector() {
        return this.authenticationProviderInjectedValue;
    }

    Injector<Endpoint> getEndpointInjector() {
        return this.endpointInjectedValue;
    }
}

