/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.remoting.AbstractRemotingSubsystemUpdate;
import org.jboss.as.remoting.ConnectorElement;
import org.jboss.as.remoting.ConnectorService;
import org.jboss.as.remoting.RemotingSubsystemElement;
import org.jboss.as.remoting.RemoveConnectorUpdate;
import org.jboss.as.remoting.SaslElement;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.security.ServerAuthenticationProvider;
import org.jboss.xnio.OptionMap;

public final class AddConnectorUpdate
extends AbstractRemotingSubsystemUpdate<Void> {
    private static final long serialVersionUID = -1238913680118311381L;
    private final String name;
    private final String socketBinding;
    private SaslElement saslElement;
    private String authenticationProvider;
    private final Map<String, String> properties = new HashMap<String, String>();

    public AddConnectorUpdate(String name, String socketBinding) {
        this.name = name;
        this.socketBinding = socketBinding;
    }

    protected <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        BatchBuilder batchBuilder = updateContext.getBatchBuilder();
        OptionMap.Builder builder = OptionMap.builder();
        if (this.saslElement != null) {
            this.saslElement.applyTo(builder);
        }
        ConnectorService connectorService = new ConnectorService();
        connectorService.setOptionMap(builder.getMap());
        UpdateResultHandler.ServiceStartListener listener = new UpdateResultHandler.ServiceStartListener(resultHandler, param);
        ServiceName connectorName = ConnectorElement.connectorName(this.name);
        BatchServiceBuilder serviceBuilder = batchBuilder.addService(connectorName, (Service)connectorService);
        serviceBuilder.addDependency(connectorName.append(new String[]{"auth-provider"}), ServerAuthenticationProvider.class, connectorService.getAuthenticationProviderInjector());
        serviceBuilder.addDependency(RemotingSubsystemElement.JBOSS_REMOTING_ENDPOINT, Endpoint.class, connectorService.getEndpointInjector());
        serviceBuilder.addListener((ServiceListener)listener);
        serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        try {
            batchBuilder.install();
        }
        catch (ServiceRegistryException e) {
            resultHandler.handleFailure((Throwable)e, param);
        }
    }

    public AbstractSubsystemUpdate<RemotingSubsystemElement, ?> getCompensatingUpdate(RemotingSubsystemElement original) {
        return new RemoveConnectorUpdate(this.name);
    }

    protected void applyUpdate(RemotingSubsystemElement element) throws UpdateFailedException {
        ConnectorElement connector = element.addConnector(this.name, this.socketBinding);
        connector.setAuthenticationProvider(this.authenticationProvider);
        connector.setSaslElement(this.saslElement);
        connector.setConnectorProperties(this.properties);
    }

    public void setSaslElement(SaslElement saslElement) {
        this.saslElement = saslElement;
    }

    public void setAuthenticationProvider(String authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }
}

