/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.pojo.service;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.as.pojo.BeanState;
import org.jboss.as.pojo.descriptor.BeanMetaDataConfig;
import org.jboss.as.pojo.descriptor.CallbackConfig;
import org.jboss.as.pojo.descriptor.DefaultConfigVisitor;
import org.jboss.as.pojo.descriptor.InstallConfig;
import org.jboss.as.pojo.descriptor.ValueConfig;
import org.jboss.as.pojo.service.BeanInfo;
import org.jboss.as.pojo.service.Callback;
import org.jboss.as.pojo.service.Configurator;
import org.jboss.as.pojo.service.InstancesService;
import org.jboss.as.pojo.service.Joinpoint;
import org.jboss.as.pojo.service.MethodJoinpoint;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public abstract class AbstractPojoPhase
implements Service<Object> {
    protected final Logger log = Logger.getLogger(this.getClass());
    private Module module;
    private BeanMetaDataConfig beanConfig;
    private DeploymentReflectionIndex index;
    private BeanInfo beanInfo;
    private Object bean;

    protected abstract BeanState getLifecycleState();

    protected abstract AbstractPojoPhase createNextPhase();

    public void start(StartContext context) throws StartException {
        try {
            AbstractPojoPhase nextPhase;
            this.executeInstalls();
            if (this.getLifecycleState().isAfter(BeanState.DESCRIBED)) {
                this.addCallbacks(true);
                this.addCallbacks(false);
                ServiceContainer registry = context.getController().getServiceContainer();
                InstancesService.addInstance((ServiceRegistry)registry, context.getChildTarget(), this.getLifecycleState(), this.getBean());
            }
            if ((nextPhase = this.createNextPhase()) != null) {
                BeanState state = this.getLifecycleState();
                BeanState next = state.next();
                BeanMetaDataConfig beanConfig = this.getBeanConfig();
                ServiceName name = BeanMetaDataConfig.toBeanName(beanConfig.getName(), next);
                ServiceTarget serviceTarget = context.getChildTarget();
                ServiceBuilder serviceBuilder = serviceTarget.addService(name, (Service)nextPhase);
                this.registerAliases(serviceBuilder, next);
                DefaultConfigVisitor visitor = new DefaultConfigVisitor(serviceBuilder, state, this.getModule(), this.getIndex(), this.getBeanInfo());
                beanConfig.visit(visitor);
                nextPhase.setModule(this.getModule());
                nextPhase.setBeanConfig(this.getBeanConfig());
                nextPhase.setIndex(this.getIndex());
                nextPhase.setBeanInfo(this.getBeanInfo());
                nextPhase.setBean(this.getBean());
                serviceBuilder.install();
            }
        }
        catch (Throwable t) {
            throw new StartException(t);
        }
    }

    protected void registerAliases(ServiceBuilder serviceBuilder, BeanState next) {
        Set<String> aliases = this.beanConfig.getAliases();
        if (aliases != null) {
            for (String alias : aliases) {
                ServiceName asn = BeanMetaDataConfig.toBeanName(alias, next);
                serviceBuilder.addAliases(new ServiceName[]{asn});
            }
        }
    }

    public Object getValue() throws IllegalStateException, IllegalArgumentException {
        return this.getBean();
    }

    public void stop(StopContext context) {
        if (this.getLifecycleState().isAfter(BeanState.DESCRIBED)) {
            InstancesService.removeInstance((ServiceRegistry)context.getController().getServiceContainer(), this.getLifecycleState(), this.getBean());
            this.removeCallbacks(true);
            this.removeCallbacks(false);
        }
        this.executeUninstalls();
    }

    private List<Joinpoint> getInstalls() {
        List<InstallConfig> installs = this.getBeanConfig().getInstalls();
        return installs != null ? this.toJoinpoints(installs) : Collections.emptyList();
    }

    private List<Joinpoint> getUninstalls() {
        List<InstallConfig> uninstalls = this.getBeanConfig().getUninstalls();
        return uninstalls != null ? this.toJoinpoints(uninstalls) : Collections.emptyList();
    }

    private List<Joinpoint> toJoinpoints(List<InstallConfig> installs) {
        ArrayList<Joinpoint> joinpoints = new ArrayList<Joinpoint>();
        for (InstallConfig ic : installs) {
            if (ic.getWhenRequired() != this.getLifecycleState()) continue;
            joinpoints.add(this.createJoinpoint(ic));
        }
        return joinpoints;
    }

    protected Joinpoint createJoinpoint(InstallConfig config) {
        String methodName = config.getMethodName();
        if (methodName == null) {
            throw new IllegalArgumentException("Null method name");
        }
        ValueConfig[] parameters = config.getParameters();
        String[] types = Configurator.getTypes(parameters);
        String dependency = config.getDependency();
        ImmediateValue target = dependency != null ? config.getBean() : new ImmediateValue(this.getBean());
        BeanInfo beanInfo = dependency != null ? (BeanInfo)config.getBeanInfo().getValue() : this.getBeanInfo();
        Method method = beanInfo.findMethod(methodName, types);
        MethodJoinpoint joinpoint = new MethodJoinpoint(method);
        joinpoint.setTarget((Value<Object>)target);
        joinpoint.setParameters(parameters);
        return joinpoint;
    }

    protected void executeInstalls() throws StartException {
        List<Joinpoint> installs = this.getInstalls();
        if (installs.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            for (i = 0; i < installs.size(); ++i) {
                installs.get(i).dispatch();
            }
        }
        catch (Throwable t) {
            this.considerUninstalls(this.getUninstalls(), i);
            throw new StartException(t);
        }
    }

    protected void considerUninstalls(List<Joinpoint> uninstalls, int index) {
        if (uninstalls == null) {
            return;
        }
        for (int j = Math.min(index, uninstalls.size() - 1); j >= 0; --j) {
            try {
                uninstalls.get(j).dispatch();
                continue;
            }
            catch (Throwable t) {
                this.log.warn((Object)("Ignoring uninstall action on target: " + uninstalls.get(j)), t);
            }
        }
    }

    protected void executeUninstalls() {
        this.considerUninstalls(this.getUninstalls(), Integer.MAX_VALUE);
    }

    protected void addCallbacks(boolean install) {
        List<CallbackConfig> configs;
        List<CallbackConfig> list = configs = install ? this.getBeanConfig().getIncallbacks() : this.getBeanConfig().getUncallbacks();
        if (configs != null) {
            for (CallbackConfig cc : configs) {
                if (cc.getWhenRequired() != this.getLifecycleState()) continue;
                Callback callback = new Callback(this.getBeanInfo(), this.getBean(), cc);
                if (install) {
                    InstancesService.addIncallback(callback);
                    continue;
                }
                InstancesService.addUncallback(callback);
            }
        }
    }

    protected void removeCallbacks(boolean install) {
        List<CallbackConfig> configs;
        List<CallbackConfig> list = configs = install ? this.getBeanConfig().getIncallbacks() : this.getBeanConfig().getUncallbacks();
        if (configs != null) {
            for (CallbackConfig cc : configs) {
                if (cc.getWhenRequired() != this.getLifecycleState()) continue;
                Callback callback = new Callback(this.getBeanInfo(), this.getBean(), cc);
                if (install) {
                    InstancesService.removeIncallback(callback);
                    continue;
                }
                InstancesService.removeUncallback(callback);
            }
        }
    }

    protected Module getModule() {
        return this.module;
    }

    protected void setModule(Module module) {
        this.module = module;
    }

    protected BeanMetaDataConfig getBeanConfig() {
        return this.beanConfig;
    }

    protected DeploymentReflectionIndex getIndex() {
        return this.index;
    }

    protected void setBeanConfig(BeanMetaDataConfig beanConfig) {
        this.beanConfig = beanConfig;
    }

    protected void setIndex(DeploymentReflectionIndex index) {
        this.index = index;
    }

    protected BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    protected void setBeanInfo(BeanInfo beanInfo) {
        this.beanInfo = beanInfo;
    }

    protected Object getBean() {
        return this.bean;
    }

    protected void setBean(Object bean) {
        this.bean = bean;
    }
}

