/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryManagerMXBean;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.platform.mbean.AbstractPlatformMBeanAttributeHandler;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.dmr.ModelNode;

public class MemoryManagerMXBeanAttributeHandler
extends AbstractPlatformMBeanAttributeHandler {
    public static MemoryManagerMXBeanAttributeHandler INSTANCE = new MemoryManagerMXBeanAttributeHandler();

    private MemoryManagerMXBeanAttributeHandler() {
    }

    @Override
    protected void executeReadAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String mmName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        String name = operation.require("name").asString();
        MemoryManagerMXBean memoryManagerMXBean = null;
        for (MemoryManagerMXBean mbean : ManagementFactory.getMemoryManagerMXBeans()) {
            if (!mmName.equals(PlatformMBeanUtil.escapeMBeanName(mbean.getName()))) continue;
            memoryManagerMXBean = mbean;
        }
        if (memoryManagerMXBean == null) {
            throw new OperationFailedException(new ModelNode().set(String.format("No MemoryManagerMXBean with name %s currently exists", mmName)));
        }
        if (PlatformMBeanUtil.JVM_MAJOR_VERSION > 6 && "object-name".equals(name)) {
            String objName = PlatformMBeanUtil.getObjectNameStringWithNameKey("java.lang:type=MemoryManager", mmName);
            context.getResult().set(objName);
        } else if ("name".equals(name)) {
            context.getResult().set(PlatformMBeanUtil.escapeMBeanName(memoryManagerMXBean.getName()));
        } else if ("valid".equals(name)) {
            context.getResult().set(memoryManagerMXBean.isValid());
        } else if ("memory-pool-names".equals(name)) {
            ModelNode result = context.getResult();
            result.setEmptyList();
            for (String pool : memoryManagerMXBean.getMemoryPoolNames()) {
                result.add(PlatformMBeanUtil.escapeMBeanName(pool));
            }
        } else {
            if (PlatformMBeanConstants.MEMORY_MANAGER_READ_ATTRIBUTES.contains(name)) {
                throw new IllegalStateException(String.format("Read support for attribute %s was not properly implemented", name));
            }
            throw MemoryManagerMXBeanAttributeHandler.unknownAttribute(operation);
        }
    }

    @Override
    protected void executeWriteAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        throw MemoryManagerMXBeanAttributeHandler.unknownAttribute(operation);
    }

    @Override
    protected void register(ManagementResourceRegistration registration) {
        if (PlatformMBeanUtil.JVM_MAJOR_VERSION > 6) {
            registration.registerReadOnlyAttribute("object-name", (OperationStepHandler)this, AttributeAccess.Storage.RUNTIME);
        }
        for (String attribute : PlatformMBeanConstants.MEMORY_MANAGER_READ_ATTRIBUTES) {
            registration.registerMetric(attribute, (OperationStepHandler)this);
        }
    }
}

