/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.configadmin;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.felix.cm.PersistenceManager;
import org.jboss.as.osgi.service.ConfigAdminService;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class DomainModelPersistenceManager
implements PersistenceManager,
BundleActivator {
    private ConfigAdminService configadminService;

    public void start(BundleContext context) throws Exception {
        ServiceReference sref = context.getServiceReference(ServiceContainer.class.getName());
        ServiceContainer serviceContainer = (ServiceContainer)context.getService(sref);
        ServiceController controller = serviceContainer.getRequiredService(ConfigAdminService.SERVICE_NAME);
        this.configadminService = (ConfigAdminService)controller.getValue();
        Hashtable<String, Integer> props = new Hashtable<String, Integer>();
        props.put("service.ranking", Integer.MAX_VALUE);
        context.registerService(PersistenceManager.class.getName(), (Object)this, props);
    }

    public void stop(BundleContext context) throws Exception {
        this.configadminService = null;
    }

    public boolean exists(String pid) {
        return this.configadminService.hasConfiguration(pid);
    }

    public Dictionary load(String pid) throws IOException {
        Dictionary props = this.configadminService.getConfiguration(pid);
        return this.addStandardProperties(pid, props);
    }

    public Enumeration getDictionaries() throws IOException {
        Vector<Dictionary<String, String>> result = new Vector<Dictionary<String, String>>();
        for (String pid : this.configadminService.getConfigurations()) {
            Dictionary props = this.configadminService.getConfiguration(pid);
            result.add(this.addStandardProperties(pid, props));
        }
        return result.elements();
    }

    public void store(String pid, Dictionary properties) throws IOException {
        this.configadminService.putConfiguration(pid, properties);
    }

    public void delete(String pid) throws IOException {
        this.configadminService.removeConfiguration(pid);
    }

    private Dictionary<String, String> addStandardProperties(String pid, Dictionary<String, String> props) {
        if (props == null) {
            return new Hashtable<String, String>();
        }
        Dictionary result = this.copy(props);
        result.put("service.pid", pid);
        return result;
    }

    private Dictionary copy(Dictionary source) {
        Hashtable copy = new Hashtable();
        if (source instanceof Map) {
            copy.putAll((Map)((Object)source));
        } else {
            Enumeration keys = source.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                copy.put(key, source.get(key));
            }
        }
        return copy;
    }
}

