/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.DefaultOperationDescriptionProvider;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.modcluster.CustomLoadMetricDefinition;
import org.jboss.as.modcluster.LoadMetricDefinition;
import org.jboss.as.modcluster.ModClusterAddCustomMetric;
import org.jboss.as.modcluster.ModClusterAddMetric;
import org.jboss.as.modcluster.ModClusterConfigAdd;
import org.jboss.as.modcluster.ModClusterExtension;
import org.jboss.as.modcluster.ModClusterRemoveCustomMetric;
import org.jboss.as.modcluster.ModClusterRemoveMetric;
import org.jboss.as.modcluster.ZeroToNegativeOneParameterCorrector;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class ModClusterConfigResourceDefinition
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition ADVERTISE_SOCKET = SimpleAttributeDefinitionBuilder.create((String)"advertise-socket", (ModelType)ModelType.STRING, (boolean)true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition CONNECTOR = SimpleAttributeDefinitionBuilder.create((String)"connector", (ModelType)ModelType.STRING, (boolean)false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition PROXY_LIST = SimpleAttributeDefinitionBuilder.create((String)"proxy-list", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition PROXY_URL = SimpleAttributeDefinitionBuilder.create((String)"proxy-url", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode("/")).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition ADVERTISE = SimpleAttributeDefinitionBuilder.create((String)"advertise", (ModelType)ModelType.BOOLEAN, (boolean)true).setDefaultValue(new ModelNode(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition ADVERTISE_SECURITY_KEY = SimpleAttributeDefinitionBuilder.create((String)"advertise-security-key", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition EXCLUDED_CONTEXTS = SimpleAttributeDefinitionBuilder.create((String)"excluded-contexts", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode("ROOT,invoker,jbossws,juddi,console")).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition AUTO_ENABLE_CONTEXTS = SimpleAttributeDefinitionBuilder.create((String)"auto-enable-contexts", (ModelType)ModelType.BOOLEAN, (boolean)true).setDefaultValue(new ModelNode(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition STOP_CONTEXT_TIMEOUT = SimpleAttributeDefinitionBuilder.create((String)"stop-context-timeout", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(10)).setMeasurementUnit(MeasurementUnit.SECONDS).setValidator((ParameterValidator)new IntRangeValidator(1, true, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition SOCKET_TIMEOUT = SimpleAttributeDefinitionBuilder.create((String)"socket-timeout", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(20)).setMeasurementUnit(MeasurementUnit.SECONDS).setValidator((ParameterValidator)new IntRangeValidator(1, true, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition STICKY_SESSION = SimpleAttributeDefinitionBuilder.create((String)"sticky-session", (ModelType)ModelType.BOOLEAN, (boolean)true).setDefaultValue(new ModelNode(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition STICKY_SESSION_REMOVE = SimpleAttributeDefinitionBuilder.create((String)"sticky-session-remove", (ModelType)ModelType.BOOLEAN, (boolean)true).setDefaultValue(new ModelNode(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition STICKY_SESSION_FORCE = SimpleAttributeDefinitionBuilder.create((String)"sticky-session-force", (ModelType)ModelType.BOOLEAN, (boolean)true).setDefaultValue(new ModelNode(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition WORKER_TIMEOUT = SimpleAttributeDefinitionBuilder.create((String)"worker-timeout", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(-1)).setMeasurementUnit(MeasurementUnit.SECONDS).setValidator((ParameterValidator)new IntRangeValidator(-1, true, true)).setCorrector((ParameterCorrector)ZeroToNegativeOneParameterCorrector.INSTANCE).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition MAX_ATTEMPTS = SimpleAttributeDefinitionBuilder.create((String)"max-attempts", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(1)).setValidator((ParameterValidator)new IntRangeValidator(-1, true, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition FLUSH_PACKETS = SimpleAttributeDefinitionBuilder.create((String)"flush-packets", (ModelType)ModelType.BOOLEAN, (boolean)true).setDefaultValue(new ModelNode(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition FLUSH_WAIT = SimpleAttributeDefinitionBuilder.create((String)"flush-wait", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(-1)).setMeasurementUnit(MeasurementUnit.SECONDS).setValidator((ParameterValidator)new IntRangeValidator(-1, true, true)).setCorrector((ParameterCorrector)ZeroToNegativeOneParameterCorrector.INSTANCE).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition PING = SimpleAttributeDefinitionBuilder.create((String)"ping", (ModelType)ModelType.INT, (boolean)true).setDefaultValue(new ModelNode(10)).setMeasurementUnit(MeasurementUnit.SECONDS).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition SMAX = SimpleAttributeDefinitionBuilder.create((String)"smax", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(-1)).setValidator((ParameterValidator)new IntRangeValidator(-1, true, true)).setCorrector((ParameterCorrector)ZeroToNegativeOneParameterCorrector.INSTANCE).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition TTL = SimpleAttributeDefinitionBuilder.create((String)"ttl", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(-1)).setMeasurementUnit(MeasurementUnit.SECONDS).setValidator((ParameterValidator)new IntRangeValidator(-1, true, true)).setCorrector((ParameterCorrector)ZeroToNegativeOneParameterCorrector.INSTANCE).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition NODE_TIMEOUT = SimpleAttributeDefinitionBuilder.create((String)"node-timeout", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode(-1)).setMeasurementUnit(MeasurementUnit.SECONDS).setValidator((ParameterValidator)new IntRangeValidator(-1, true, true)).setCorrector((ParameterCorrector)ZeroToNegativeOneParameterCorrector.INSTANCE).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition BALANCER = SimpleAttributeDefinitionBuilder.create((String)"balancer", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition LOAD_BALANCING_GROUP = SimpleAttributeDefinitionBuilder.create((String)"load-balancing-group", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).addAlternatives(new String[]{"domain"}).build();
    static final SimpleAttributeDefinition SIMPLE_LOAD_PROVIDER = SimpleAttributeDefinitionBuilder.create((String)"simple-load-provider", (ModelType)ModelType.INT, (boolean)true).addFlag(AttributeAccess.Flag.RESTART_ALL_SERVICES).setXmlName("factor").setAllowExpression(true).setValidator((ParameterValidator)new IntRangeValidator(1, true, true)).build();
    static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{ADVERTISE_SOCKET, PROXY_LIST, PROXY_URL, BALANCER, ADVERTISE, ADVERTISE_SECURITY_KEY, EXCLUDED_CONTEXTS, AUTO_ENABLE_CONTEXTS, STOP_CONTEXT_TIMEOUT, SOCKET_TIMEOUT, STICKY_SESSION, STICKY_SESSION_REMOVE, STICKY_SESSION_FORCE, WORKER_TIMEOUT, MAX_ATTEMPTS, FLUSH_PACKETS, FLUSH_WAIT, PING, SMAX, TTL, NODE_TIMEOUT, LOAD_BALANCING_GROUP, CONNECTOR};
    public static final Map<String, SimpleAttributeDefinition> ATTRIBUTES_BY_NAME;

    public ModClusterConfigResourceDefinition() {
        super(ModClusterExtension.CONFIGURATION_PATH, (ResourceDescriptionResolver)ModClusterExtension.getResourceDescriptionResolver("configuration"), (OperationStepHandler)ModClusterConfigAdd.INSTANCE, (OperationStepHandler)new ReloadRequiredRemoveStepHandler());
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (SimpleAttributeDefinition attr : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute((AttributeDefinition)attr, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{attr}));
        }
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)SIMPLE_LOAD_PROVIDER, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{SIMPLE_LOAD_PROVIDER}));
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        ResourceDescriptionResolver rootResolver = this.getResourceDescriptionResolver();
        EnumSet<OperationEntry.Flag> runtimeOnlyFlags = EnumSet.of(OperationEntry.Flag.RUNTIME_ONLY);
        DefaultOperationDescriptionProvider addMetric = new DefaultOperationDescriptionProvider("add-metric", rootResolver, (AttributeDefinition[])LoadMetricDefinition.ATTRIBUTES);
        resourceRegistration.registerOperationHandler("add-metric", (OperationStepHandler)ModClusterAddMetric.INSTANCE, (DescriptionProvider)addMetric, false, runtimeOnlyFlags);
        DefaultOperationDescriptionProvider addCustomMetric = new DefaultOperationDescriptionProvider("add-custom-metric", rootResolver, (AttributeDefinition[])CustomLoadMetricDefinition.ATTRIBUTES);
        resourceRegistration.registerOperationHandler("add-custom-metric", (OperationStepHandler)ModClusterAddCustomMetric.INSTANCE, (DescriptionProvider)addCustomMetric, false, runtimeOnlyFlags);
        DefaultOperationDescriptionProvider removeMetric = new DefaultOperationDescriptionProvider("remove-metric", rootResolver, new AttributeDefinition[]{LoadMetricDefinition.TYPE});
        resourceRegistration.registerOperationHandler("remove-metric", (OperationStepHandler)ModClusterRemoveMetric.INSTANCE, (DescriptionProvider)removeMetric, false, runtimeOnlyFlags);
        DefaultOperationDescriptionProvider removeCustomMetric = new DefaultOperationDescriptionProvider("remove-custom-metric", rootResolver, new AttributeDefinition[]{CustomLoadMetricDefinition.CLASS});
        resourceRegistration.registerOperationHandler("remove-custom-metric", (OperationStepHandler)ModClusterRemoveCustomMetric.INSTANCE, (DescriptionProvider)removeCustomMetric, false, runtimeOnlyFlags);
    }

    static {
        HashMap<String, SimpleAttributeDefinition> attrs = new HashMap<String, SimpleAttributeDefinition>();
        for (SimpleAttributeDefinition attr : ATTRIBUTES) {
            attrs.put(attr.getName(), attr);
        }
        ATTRIBUTES_BY_NAME = Collections.unmodifiableMap(attrs);
    }
}

