/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs;

import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.jaxrs.JaxrsLogger;
import org.jboss.as.jaxrs.JaxrsSubsystemAdd;
import org.jboss.as.jaxrs.JaxrsSubsystemProviders;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class JaxrsExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "jaxrs";
    public static final String NAMESPACE = "urn:jboss:domain:jaxrs:1.0";
    private static final JaxrsSubsystemParser parser = new JaxrsSubsystemParser();
    static final DescriptionProvider SUBSYSTEM_DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return JaxrsSubsystemProviders.getSubsystemDescription(locale);
        }
    };
    static final DescriptionProvider SUBSYSTEM_ADD_DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return JaxrsSubsystemProviders.getSubsystemAddDescription(locale);
        }
    };
    static final DescriptionProvider SUBSYSTEM_REMOVE_DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return JaxrsSubsystemProviders.getSubsystemRemoveDescription(locale);
        }
    };

    public void initialize(ExtensionContext context) {
        JaxrsLogger.JAXRS_LOGGER.debug("Activating JAX-RS Extension");
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 0);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel(SUBSYSTEM_DESCRIPTION);
        registration.registerOperationHandler("add", (OperationStepHandler)JaxrsSubsystemAdd.INSTANCE, SUBSYSTEM_ADD_DESCRIPTION, false);
        registration.registerOperationHandler("describe", (OperationStepHandler)JaxrsSubsystemDescribeHandler.INSTANCE, (DescriptionProvider)JaxrsSubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        registration.registerOperationHandler("remove", (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE, SUBSYSTEM_REMOVE_DESCRIPTION, false);
        subsystem.registerXMLElementWriter((XMLElementWriter)parser);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, NAMESPACE, (XMLElementReader)parser);
    }

    private static ModelNode createAddSubSystemOperation() {
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").add("subsystem", SUBSYSTEM_NAME);
        return subsystem;
    }

    private static class JaxrsSubsystemDescribeHandler
    implements OperationStepHandler,
    DescriptionProvider {
        static final JaxrsSubsystemDescribeHandler INSTANCE = new JaxrsSubsystemDescribeHandler();

        private JaxrsSubsystemDescribeHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.getResult().add(JaxrsExtension.createAddSubSystemOperation());
            context.completeStep();
        }

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    }

    static class JaxrsSubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        JaxrsSubsystemParser() {
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            list.add(JaxrsExtension.createAddSubSystemOperation());
        }

        public void writeContent(XMLExtendedStreamWriter streamWriter, SubsystemMarshallingContext context) throws XMLStreamException {
            context.startSubsystemElement(JaxrsExtension.NAMESPACE, false);
            streamWriter.writeEndElement();
        }
    }
}

