/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.messagedriven;

import java.util.Properties;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.component.EJBComponentCreateService;
import org.jboss.as.ejb3.component.messagedriven.DefaultResourceAdapterService;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponent;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentDescription;
import org.jboss.as.ejb3.component.pool.PoolConfig;
import org.jboss.as.ejb3.deployment.ApplicationExceptions;
import org.jboss.as.ejb3.inflow.EndpointDeployer;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;

public class MessageDrivenComponentCreateService
extends EJBComponentCreateService {
    private final Class<?> messageListenerInterface;
    private final Properties activationProps;
    private final String resourceAdapterName;
    private final InjectedValue<ResourceAdapter> resourceAdapterInjectedValue = new InjectedValue();
    private final InjectedValue<PoolConfig> poolConfig = new InjectedValue();
    private final InjectedValue<DefaultResourceAdapterService> defaultResourceAdapterServiceInjectedValue = new InjectedValue();

    public MessageDrivenComponentCreateService(ComponentConfiguration componentConfiguration, ApplicationExceptions ejbJarConfiguration) {
        super(componentConfiguration, ejbJarConfiguration);
        MessageDrivenComponentDescription componentDescription = (MessageDrivenComponentDescription)componentConfiguration.getComponentDescription();
        this.resourceAdapterName = this.stripDotRarSuffix(componentDescription.getResourceAdapterName());
        this.messageListenerInterface = ((ViewConfiguration)componentConfiguration.getViews().get(0)).getViewClass();
        this.activationProps = componentDescription.getActivationProps();
    }

    public void start(StartContext context) throws StartException {
        super.start(context);
        EjbLogger.ROOT_LOGGER.logMDBStart(this.getComponentName(), this.resourceAdapterName);
    }

    protected BasicComponent createComponent() {
        String activeResourceAdapterName = this.resourceAdapterName == null ? ((DefaultResourceAdapterService)this.defaultResourceAdapterServiceInjectedValue.getValue()).getDefaultResourceAdapterName() : this.resourceAdapterName;
        ActivationSpec activationSpec = this.getEndpointDeployer().createActivationSpecs(activeResourceAdapterName, this.messageListenerInterface, this.activationProps, this.getDeploymentClassLoader());
        MessageDrivenComponent component = new MessageDrivenComponent(this, this.messageListenerInterface, activationSpec);
        ResourceAdapter resourceAdapter = (ResourceAdapter)this.resourceAdapterInjectedValue.getValue();
        component.setResourceAdapter(resourceAdapter);
        return component;
    }

    Injector<DefaultResourceAdapterService> getDefaultResourceAdapterServiceInjector() {
        return this.defaultResourceAdapterServiceInjectedValue;
    }

    PoolConfig getPoolConfig() {
        return (PoolConfig)this.poolConfig.getOptionalValue();
    }

    public InjectedValue<PoolConfig> getPoolConfigInjector() {
        return this.poolConfig;
    }

    private ClassLoader getDeploymentClassLoader() {
        return this.getComponentClass().getClassLoader();
    }

    private EndpointDeployer getEndpointDeployer() {
        return this.getEJBUtilities();
    }

    public InjectedValue<ResourceAdapter> getResourceAdapterInjector() {
        return this.resourceAdapterInjectedValue;
    }

    private String stripDotRarSuffix(String raName) {
        if (raName == null) {
            return null;
        }
        if (raName.endsWith(".rar")) {
            return raName.substring(0, raName.indexOf(".rar"));
        }
        return raName;
    }
}

