/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import java.util.List;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.metadata.ClassAnnotationInformation;
import org.jboss.as.ee.structure.Attachments;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.ejb3.security.metadata.EJBBoundSecurityMetaData;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.ejb3.annotation.SecurityDomain;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;

public class SecurityDomainMergingProcessor
extends AbstractMergingProcessor<EJBComponentDescription> {
    public SecurityDomainMergingProcessor() {
        super(EJBComponentDescription.class);
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, EJBComponentDescription description) throws DeploymentUnitProcessingException {
        EEModuleClassDescription clazz = applicationClasses.getClassByName(componentClass.getName());
        if (clazz == null) {
            return;
        }
        ClassAnnotationInformation securityDomain = clazz.getAnnotationInformation(SecurityDomain.class);
        if (securityDomain == null) {
            return;
        }
        if (!securityDomain.getClassLevelAnnotations().isEmpty()) {
            if (EjbLogger.ROOT_LOGGER.isDebugEnabled()) {
                EjbLogger.ROOT_LOGGER.debug("EJB " + description.getEJBName() + " is part of security domain " + (String)securityDomain.getClassLevelAnnotations().get(0));
            }
            description.setSecurityDomain((String)securityDomain.getClassLevelAnnotations().get(0));
        }
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, EJBComponentDescription description) throws DeploymentUnitProcessingException {
        List securityMetaDatas;
        AssemblyDescriptorMetaData assemblyMetadata;
        String securityDomain = this.getJBossAppSecurityDomain(deploymentUnit);
        String globalSecurityDomain = null;
        EjbJarMetaData ejbJarMetaData = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        if (ejbJarMetaData != null && (assemblyMetadata = ejbJarMetaData.getAssemblyDescriptor()) != null && (securityMetaDatas = assemblyMetadata.getAny(EJBBoundSecurityMetaData.class)) != null) {
            for (EJBBoundSecurityMetaData securityMetaData : securityMetaDatas) {
                if (securityMetaData.getEjbName().equals(description.getComponentName())) {
                    securityDomain = securityMetaData.getSecurityDomain();
                    break;
                }
                if (!securityMetaData.getEjbName().equals("*")) continue;
                globalSecurityDomain = securityMetaData.getSecurityDomain();
            }
        }
        if (securityDomain != null) {
            description.setSecurityDomain(securityDomain);
        } else if (globalSecurityDomain != null) {
            description.setSecurityDomain(globalSecurityDomain);
        }
    }

    private String getJBossAppSecurityDomain(DeploymentUnit deploymentUnit) {
        JBossAppMetaData jbossAppMetaData;
        String securityDomain = null;
        DeploymentUnit parent = deploymentUnit.getParent();
        if (parent != null && (jbossAppMetaData = (JBossAppMetaData)parent.getAttachment(Attachments.JBOSS_APP_METADATA)) != null) {
            securityDomain = jbossAppMetaData.getSecurityDomain();
        }
        return securityDomain;
    }
}

