/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.ejb.EJBException;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ejb3.cache.Cacheable;
import org.jboss.as.ejb3.component.InvokeMethodOnTargetInterceptor;
import org.jboss.as.ejb3.component.session.SessionBeanComponentInstance;
import org.jboss.as.ejb3.component.stateful.CurrentSynchronizationCallback;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.naming.ManagedReference;
import org.jboss.ejb.client.SessionID;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;

public class StatefulSessionComponentInstance
extends SessionBeanComponentInstance
implements Cacheable<SessionID> {
    private static final long serialVersionUID = 3803978357389448971L;
    private final SessionID id;
    private transient Interceptor afterBegin;
    private transient Interceptor afterCompletion;
    private transient Interceptor beforeCompletion;
    private transient Collection<Interceptor> prePassivate;
    private transient Collection<Interceptor> postActivate;
    private transient Interceptor ejb2XRemoveInterceptor;

    protected StatefulSessionComponentInstance(StatefulSessionComponent component, AtomicReference<ManagedReference> instanceReference, Interceptor preDestroyInterceptor, Map<Method, Interceptor> methodInterceptors) {
        super(component, instanceReference, preDestroyInterceptor, methodInterceptors);
        UUID uuid = UUID.randomUUID();
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        this.id = SessionID.createSessionID((byte[])bb.array());
        this.createInterceptors();
    }

    private void createInterceptors() {
        StatefulSessionComponent component = this.getComponent();
        this.afterBegin = component.createInterceptor(component.getAfterBegin());
        this.afterCompletion = component.createInterceptor(component.getAfterCompletion());
        this.beforeCompletion = component.createInterceptor(component.getBeforeCompletion());
        this.prePassivate = this.createInterceptors(component, component.getPrePassivate());
        this.postActivate = this.createInterceptors(component, component.getPostActivate());
        this.ejb2XRemoveInterceptor = component.createInterceptor(component.getEjb2XRemoveMethod());
    }

    private Collection<Interceptor> createInterceptors(StatefulSessionComponent component, Collection<InterceptorFactory> factories) {
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>(factories.size());
        for (InterceptorFactory factory : factories) {
            interceptors.add(component.createInterceptor(factory));
        }
        return Collections.unmodifiableList(interceptors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterBegin() {
        CurrentSynchronizationCallback.set(CurrentSynchronizationCallback.CallbackType.AFTER_BEGIN);
        try {
            this.execute(this.afterBegin, this.getComponent().getAfterBeginMethod(), new Object[0]);
        }
        finally {
            CurrentSynchronizationCallback.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterCompletion(boolean committed) {
        CurrentSynchronizationCallback.set(CurrentSynchronizationCallback.CallbackType.AFTER_COMPLETION);
        try {
            this.execute(this.afterCompletion, this.getComponent().getAfterCompletionMethod(), committed);
        }
        finally {
            CurrentSynchronizationCallback.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beforeCompletion() {
        CurrentSynchronizationCallback.set(CurrentSynchronizationCallback.CallbackType.BEFORE_COMPLETION);
        try {
            this.execute(this.beforeCompletion, this.getComponent().getBeforeCompletionMethod(), new Object[0]);
        }
        finally {
            CurrentSynchronizationCallback.clear();
        }
    }

    protected void prePassivate() {
        for (Interceptor interceptor : this.prePassivate) {
            this.execute(interceptor, null, new Object[0]);
        }
    }

    protected void postActivate() {
        for (Interceptor interceptor : this.postActivate) {
            this.execute(interceptor, null, new Object[0]);
        }
    }

    @Override
    public void discard() {
        if (!this.isDiscarded()) {
            super.discard();
            this.getComponent().getCache().discard(this.id);
        }
    }

    private Object execute(Interceptor interceptor, Method method, Object ... parameters) {
        if (interceptor == null) {
            return null;
        }
        InterceptorContext interceptorContext = new InterceptorContext();
        interceptorContext.setMethod(method);
        interceptorContext.putPrivateData(Component.class, (Object)this.getComponent());
        interceptorContext.putPrivateData(ComponentInstance.class, (Object)this);
        interceptorContext.putPrivateData(InvokeMethodOnTargetInterceptor.PARAMETERS_KEY, (Object)parameters);
        interceptorContext.setContextData(new HashMap());
        try {
            return interceptor.processInvocation(interceptorContext);
        }
        catch (Error e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    @Override
    public StatefulSessionComponent getComponent() {
        return (StatefulSessionComponent)super.getComponent();
    }

    @Override
    public boolean isModified() {
        return true;
    }

    @Override
    public SessionID getId() {
        return this.id;
    }

    public Interceptor getEjb2XRemoveInterceptor() {
        return this.ejb2XRemoveInterceptor;
    }

    public String toString() {
        return " Instance of " + this.getComponent().getComponentName() + " {" + this.id + "}";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.createInterceptors();
    }
}

