/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.ejb3.deployment.DeploymentRepository;
import org.jboss.as.ejb3.remote.EJBRemoteConnectorService;
import org.jboss.as.ejb3.remote.EJBRemoteTransactionsRepository;
import org.jboss.as.ejb3.subsystem.EJB3ThreadPoolAdd;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.txn.service.TransactionManagerService;
import org.jboss.as.txn.service.UserTransactionService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.remoting3.Endpoint;

public class EJB3RemoteServiceAdd
extends AbstractBoottimeAddStepHandler {
    static final EJB3RemoteServiceAdd INSTANCE = new EJB3RemoteServiceAdd();

    private EJB3RemoteServiceAdd() {
    }

    static ModelNode create(String connectorName, String threadPoolName) {
        ModelNode address = new ModelNode();
        address.add("subsystem", "ejb3");
        address.add("service", "remote");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(address);
        operation.get("connector-ref").set(connectorName);
        operation.get("thread-pool-name").set(threadPoolName);
        return operation;
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        newControllers.add(this.installRuntimeService(context, model, verificationHandler));
        EJBRemoteTransactionsRepository transactionsRepository = new EJBRemoteTransactionsRepository();
        ServiceTarget serviceTarget = context.getServiceTarget();
        ServiceController transactionRepositoryServiceController = serviceTarget.addService(EJBRemoteTransactionsRepository.SERVICE_NAME, (Service)transactionsRepository).addDependency(TransactionManagerService.SERVICE_NAME, TransactionManager.class, transactionsRepository.getTransactionManagerInjector()).addDependency(UserTransactionService.SERVICE_NAME, UserTransaction.class, transactionsRepository.getUserTransactionInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
        newControllers.add(transactionRepositoryServiceController);
    }

    ServiceController<EJBRemoteConnectorService> installRuntimeService(OperationContext context, ModelNode model, ServiceVerificationHandler verificationHandler) {
        String connectorName = model.require("connector-ref").asString();
        String threadPoolName = model.require("thread-pool-name").asString();
        ServiceTarget serviceTarget = context.getServiceTarget();
        EJBRemoteConnectorService service = new EJBRemoteConnectorService(1, new String[]{"river"});
        ServiceBuilder ejbRemoteConnectorServiceBuilder = serviceTarget.addService(EJBRemoteConnectorService.SERVICE_NAME, (Service)service);
        ejbRemoteConnectorServiceBuilder.addDependency(RemotingServices.SUBSYSTEM_ENDPOINT, Endpoint.class, service.getEndpointInjector());
        ejbRemoteConnectorServiceBuilder.addDependency(EJB3ThreadPoolAdd.BASE_SERVICE_NAME.append(new String[]{threadPoolName}), ExecutorService.class, service.getExecutorService()).addDependency(DeploymentRepository.SERVICE_NAME, DeploymentRepository.class, service.getDeploymentRepositoryInjector()).addDependency(EJBRemoteTransactionsRepository.SERVICE_NAME, EJBRemoteTransactionsRepository.class, service.getEJBRemoteTransactionsRepositoryInjector()).setInitialMode(ServiceController.Mode.ACTIVE);
        if (verificationHandler != null) {
            ejbRemoteConnectorServiceBuilder.addListener((ServiceListener)verificationHandler);
        }
        return ejbRemoteConnectorServiceBuilder.install();
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        model.get("connector-ref").set(operation.require("connector-ref").asString());
        model.get("thread-pool-name").set(operation.require("thread-pool-name").asString());
    }
}

