/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote.protocol.versionone;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ejb3.component.entity.EntityBeanComponent;
import org.jboss.as.ejb3.component.interceptors.AsyncInvocationTask;
import org.jboss.as.ejb3.component.interceptors.CancellationFlag;
import org.jboss.as.ejb3.component.session.SessionBeanComponent;
import org.jboss.as.ejb3.deployment.DeploymentRepository;
import org.jboss.as.ejb3.deployment.EjbDeploymentInformation;
import org.jboss.as.ejb3.remote.protocol.versionone.EJBIdentifierBasedMessageHandler;
import org.jboss.as.ejb3.remote.protocol.versionone.SecurityActions;
import org.jboss.as.security.remoting.RemotingContext;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EntityEJBLocator;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.invocation.InterceptorContext;
import org.jboss.logging.Logger;
import org.jboss.marshalling.AbstractClassResolver;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.MessageInputStream;
import org.xnio.IoUtils;

class MethodInvocationMessageHandler
extends EJBIdentifierBasedMessageHandler {
    private static final Logger logger = Logger.getLogger(MethodInvocationMessageHandler.class);
    private static final char METHOD_PARAM_TYPE_SEPARATOR = ',';
    private static final byte HEADER_METHOD_INVOCATION_RESPONSE = 5;
    private static final byte HEADER_ASYNC_METHOD_NOTIFICATION = 14;
    private final ExecutorService executorService;
    private final MarshallerFactory marshallerFactory;

    MethodInvocationMessageHandler(DeploymentRepository deploymentRepository, MarshallerFactory marshallerFactory, ExecutorService executorService) {
        super(deploymentRepository);
        this.marshallerFactory = marshallerFactory;
        this.executorService = executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processMessage(final Channel channel, MessageInputStream messageInputStream) throws IOException {
        String beanName;
        String distinctName;
        String moduleName;
        String appName;
        DataInputStream input = new DataInputStream((InputStream)messageInputStream);
        final short invocationId = input.readShort();
        String methodName = input.readUTF();
        String[] methodParamTypes = null;
        String signature = input.readUTF();
        methodParamTypes = signature.isEmpty() ? new String[]{} : signature.split(String.valueOf(','));
        ClassLoaderSwitchingClassResolver classResolver = new ClassLoaderSwitchingClassResolver(Thread.currentThread().getContextClassLoader());
        Unmarshaller unmarshaller = this.prepareForUnMarshalling(this.marshallerFactory, (ClassResolver)classResolver, input);
        try {
            appName = (String)unmarshaller.readObject();
            moduleName = (String)unmarshaller.readObject();
            distinctName = (String)unmarshaller.readObject();
            beanName = (String)unmarshaller.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        EjbDeploymentInformation ejbDeploymentInformation = this.findEJB(appName, moduleName, distinctName, beanName);
        if (ejbDeploymentInformation == null) {
            this.writeNoSuchEJBFailureMessage(channel, invocationId, appName, moduleName, distinctName, beanName, null);
            return;
        }
        ClassLoader tccl = SecurityActions.getContextClassLoader();
        Runnable runnable = null;
        try {
            Map<String, Object> attachments;
            EJBLocator locator;
            SecurityActions.setContextClassLoader(ejbDeploymentInformation.getDeploymentClassLoader());
            classResolver.switchClassLoader(ejbDeploymentInformation.getDeploymentClassLoader());
            try {
                locator = (EJBLocator)unmarshaller.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            String viewClassName = locator.getViewType().getName();
            if (!ejbDeploymentInformation.getViewNames().contains(viewClassName)) {
                this.writeNoSuchEJBFailureMessage(channel, invocationId, appName, moduleName, distinctName, beanName, viewClassName);
                return;
            }
            final ComponentView componentView = ejbDeploymentInformation.getView(viewClassName);
            final Method invokedMethod = this.findMethod(componentView, methodName, methodParamTypes);
            if (invokedMethod == null) {
                this.writeNoSuchEJBMethodFailureMessage(channel, invocationId, appName, moduleName, distinctName, beanName, viewClassName, methodName, methodParamTypes);
                return;
            }
            final Object[] methodParams = new Object[methodParamTypes.length];
            if (methodParamTypes.length > 0) {
                for (int i = 0; i < methodParamTypes.length; ++i) {
                    try {
                        methodParams[i] = unmarshaller.readObject();
                        continue;
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new RuntimeException(cnfe);
                    }
                }
            }
            try {
                attachments = this.readAttachments((ObjectInput)unmarshaller);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException(cnfe);
            }
            unmarshaller.finish();
            runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (componentView.isAsynchronous(invokedMethod)) {
                        try {
                            MethodInvocationMessageHandler.this.writeAsyncMethodNotification(channel, invocationId);
                        }
                        catch (Throwable t) {
                            logger.warn((Object)("Method " + invokedMethod + " was a async method but the client could not be informed about the same. This will mean that the client might block till the method completes"), t);
                        }
                    }
                    Object result = null;
                    RemotingContext.setConnection((Connection)channel.getConnection());
                    try {
                        result = MethodInvocationMessageHandler.this.invokeMethod(componentView, invokedMethod, methodParams, locator, attachments);
                    }
                    catch (Throwable throwable) {
                        try {
                            MethodInvocationMessageHandler.this.writeException(channel, MethodInvocationMessageHandler.this.marshallerFactory, invocationId, throwable, attachments);
                        }
                        catch (IOException ioe) {
                            logger.error((Object)("Error invoking method " + invokedMethod + " on bean named " + beanName + " for appname " + appName + " modulename " + moduleName + " distinctname " + distinctName), throwable);
                            logger.error((Object)("Could not write method invocation failure for method " + invokedMethod + " on bean named " + beanName + " for appname " + appName + " modulename " + moduleName + " distinctname " + distinctName + " due to "), (Throwable)ioe);
                            IoUtils.safeClose((Closeable)channel);
                            return;
                        }
                    }
                    finally {
                        RemotingContext.clear();
                    }
                    try {
                        MethodInvocationMessageHandler.this.writeMethodInvocationResponse(channel, invocationId, result, attachments);
                    }
                    catch (IOException ioe) {
                        logger.error((Object)("Could not write method invocation result for method " + invokedMethod + " on bean named " + beanName + " for appname " + appName + " modulename " + moduleName + " distinctname " + distinctName + " due to "), (Throwable)ioe);
                        IoUtils.safeClose((Closeable)channel);
                        return;
                    }
                }
            };
        }
        finally {
            SecurityActions.setContextClassLoader(tccl);
        }
        this.executorService.submit(runnable);
    }

    private Object invokeMethod(final ComponentView componentView, Method method, Object[] args, EJBLocator ejbLocator, Map<String, Object> attachments) throws Throwable {
        final InterceptorContext interceptorContext = new InterceptorContext();
        interceptorContext.setParameters(args);
        interceptorContext.setMethod(method);
        interceptorContext.setContextData(new HashMap());
        interceptorContext.putPrivateData(Component.class, (Object)componentView.getComponent());
        interceptorContext.putPrivateData(ComponentView.class, (Object)componentView);
        if (attachments != null) {
            for (Map.Entry<String, Object> attachment : attachments.entrySet()) {
                if (attachment == null) continue;
                String key = attachment.getKey();
                Object value = attachment.getValue();
                interceptorContext.putPrivateData((Object)key, value);
            }
        }
        if (ejbLocator instanceof StatefulEJBLocator) {
            interceptorContext.putPrivateData(SessionID.class, (Object)((StatefulEJBLocator)ejbLocator).getSessionId());
        } else if (ejbLocator instanceof EntityEJBLocator) {
            Object primaryKey = ((EntityEJBLocator)ejbLocator).getPrimaryKey();
            interceptorContext.putPrivateData(EntityBeanComponent.PRIMARY_KEY_CONTEXT_KEY, primaryKey);
        }
        if (componentView.isAsynchronous(method)) {
            Component component = componentView.getComponent();
            if (!(component instanceof SessionBeanComponent)) {
                logger.warn((Object)("Asynchronous invocations are only supported on session beans. Bean class " + component.getComponentClass() + " is not a session bean, invocation on method " + method + " will have no asynchronous semantics"));
                return componentView.invoke(interceptorContext);
            }
            SessionBeanComponent sessionBeanComponent = (SessionBeanComponent)componentView.getComponent();
            CancellationFlag cancellationFlag = new CancellationFlag();
            interceptorContext.putPrivateData(CancellationFlag.class, (Object)cancellationFlag);
            AsyncInvocationTask asyncInvocationTask = new AsyncInvocationTask(cancellationFlag){

                @Override
                protected Object runInvocation() throws Exception {
                    return componentView.invoke(interceptorContext);
                }
            };
            sessionBeanComponent.getAsynchronousExecutor().submit(asyncInvocationTask);
            return asyncInvocationTask.get();
        }
        return componentView.invoke(interceptorContext);
    }

    private Method findMethod(ComponentView componentView, String methodName, String[] paramTypes) {
        Set viewMethods = componentView.getViewMethods();
        for (Method method : viewMethods) {
            Class<?>[] methodParamTypes;
            if (!method.getName().equals(methodName) || (methodParamTypes = method.getParameterTypes()).length != paramTypes.length) continue;
            boolean found = true;
            for (int i = 0; i < methodParamTypes.length; ++i) {
                if (methodParamTypes[i].getName().equals(paramTypes[i])) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return method;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMethodInvocationResponse(Channel channel, short invocationId, Object result, Map<String, Object> attachments) throws IOException {
        DataOutputStream outputStream = new DataOutputStream((OutputStream)channel.writeMessage());
        try {
            outputStream.write(5);
            outputStream.writeShort(invocationId);
            Marshaller marshaller = this.prepareForMarshalling(this.marshallerFactory, outputStream);
            marshaller.writeObject(result);
            this.writeAttachments((ObjectOutput)marshaller, attachments);
            marshaller.finish();
        }
        finally {
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAsyncMethodNotification(Channel channel, short invocationId) throws IOException {
        DataOutputStream outputStream = new DataOutputStream((OutputStream)channel.writeMessage());
        try {
            outputStream.write(14);
            outputStream.writeShort(invocationId);
        }
        finally {
            outputStream.close();
        }
    }

    private class ClassLoaderSwitchingClassResolver
    extends AbstractClassResolver {
        private ClassLoader currentClassLoader;

        ClassLoaderSwitchingClassResolver(ClassLoader classLoader) {
            this.currentClassLoader = classLoader;
        }

        void switchClassLoader(ClassLoader newCL) {
            this.currentClassLoader = newCL;
        }

        protected ClassLoader getClassLoader() {
            return this.currentClassLoader;
        }
    }
}

