/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote.protocol.versionone;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.ejb3.remote.protocol.versionone.MessageHandler;
import org.jboss.as.ejb3.remote.protocol.versionone.ProtocolV1ClassTable;
import org.jboss.as.ejb3.remote.protocol.versionone.ProtocolV1ObjectTable;
import org.jboss.ejb.client.remoting.PackedInteger;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.remoting3.Channel;

abstract class AbstractMessageHandler
implements MessageHandler {
    protected static final byte HEADER_NO_SUCH_EJB_FAILURE = 10;
    protected static final byte HEADER_NO_SUCH_EJB_METHOD_FAILURE = 11;
    protected static final byte HEADER_SESSION_NOT_ACTIVE_FAILURE = 12;
    private static final byte HEADER_INVOCATION_EXCEPTION = 6;

    AbstractMessageHandler() {
    }

    protected Map<String, Object> readAttachments(ObjectInput input) throws IOException, ClassNotFoundException {
        int numAttachments = input.readByte();
        if (numAttachments == 0) {
            return null;
        }
        HashMap<String, Object> attachments = new HashMap<String, Object>(numAttachments);
        for (int i = 0; i < numAttachments; ++i) {
            String key = (String)input.readObject();
            Object val = input.readObject();
            attachments.put(key, val);
        }
        return attachments;
    }

    protected void writeAttachments(ObjectOutput output, Map<String, Object> attachments) throws IOException {
        if (attachments == null) {
            output.writeByte(0);
            return;
        }
        PackedInteger.writePackedInteger((DataOutput)output, (int)attachments.size());
        for (Map.Entry<String, Object> entry : attachments.entrySet()) {
            output.writeObject(entry.getKey());
            output.writeObject(entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeException(Channel channel, MarshallerFactory marshallerFactory, short invocationId, Throwable t, Map<String, Object> attachments) throws IOException {
        DataOutputStream outputStream = new DataOutputStream((OutputStream)channel.writeMessage());
        try {
            outputStream.write(6);
            outputStream.writeShort(invocationId);
            Marshaller marshaller = this.prepareForMarshalling(marshallerFactory, outputStream);
            marshaller.writeObject((Object)t);
            this.writeAttachments((ObjectOutput)marshaller, attachments);
            marshaller.finish();
        }
        finally {
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeInvocationFailure(Channel channel, byte messageHeader, short invocationId, String failureMessage) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)channel.writeMessage());
        try {
            dataOutputStream.writeByte(messageHeader);
            dataOutputStream.writeShort(invocationId);
            dataOutputStream.writeUTF(failureMessage);
        }
        finally {
            dataOutputStream.close();
        }
    }

    protected void writeNoSuchEJBFailureMessage(Channel channel, short invocationId, String appName, String moduleName, String distinctname, String beanName, String viewClassName) throws IOException {
        StringBuffer sb = new StringBuffer("No such EJB[");
        sb.append("appname=").append(appName).append(", ");
        sb.append("modulename=").append(moduleName).append(", ");
        sb.append("distinctname=").append(distinctname).append(", ");
        sb.append("beanname=").append(beanName).append(", ");
        sb.append("viewclassname=").append(viewClassName).append("]");
        this.writeInvocationFailure(channel, (byte)10, invocationId, sb.toString());
    }

    protected void writeSessionNotActiveFailureMessage(Channel channel, short invocationId, String appName, String moduleName, String distinctname, String beanName) throws IOException {
        StringBuffer sb = new StringBuffer("Session not active for EJB[");
        sb.append("appname=").append(appName).append(", ");
        sb.append("modulename=").append(moduleName).append(", ");
        sb.append("distinctname=").append(distinctname).append(", ");
        sb.append("beanname=").append(beanName).append("]");
        this.writeInvocationFailure(channel, (byte)12, invocationId, sb.toString());
    }

    protected void writeNoSuchEJBMethodFailureMessage(Channel channel, short invocationId, String appName, String moduleName, String distinctname, String beanName, String viewClassName, String methodName, String[] methodParamTypes) throws IOException {
        StringBuffer sb = new StringBuffer("No such method ");
        sb.append(methodName).append("(");
        if (methodParamTypes != null) {
            for (int i = 0; i < methodParamTypes.length; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(methodParamTypes[i]);
            }
        }
        sb.append(") on EJB[");
        sb.append("appname=").append(appName).append(", ");
        sb.append("modulename=").append(moduleName).append(", ");
        sb.append("distinctname=").append(distinctname).append(", ");
        sb.append("beanname=").append(beanName).append(", ");
        sb.append("viewclassname=").append(viewClassName).append("]");
        this.writeInvocationFailure(channel, (byte)11, invocationId, sb.toString());
    }

    protected Marshaller prepareForMarshalling(MarshallerFactory marshallerFactory, final DataOutput dataOutput) throws IOException {
        Marshaller marshaller = this.getMarshaller(marshallerFactory);
        OutputStream outputStream = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                int byteToWrite = b & 0xFF;
                dataOutput.write(byteToWrite);
            }
        };
        ByteOutput byteOutput = Marshalling.createByteOutput((OutputStream)outputStream);
        marshaller.start(byteOutput);
        return marshaller;
    }

    private Marshaller getMarshaller(MarshallerFactory marshallerFactory) throws IOException {
        MarshallingConfiguration marshallingConfiguration = new MarshallingConfiguration();
        marshallingConfiguration.setClassTable((ClassTable)ProtocolV1ClassTable.INSTANCE);
        marshallingConfiguration.setObjectTable((ObjectTable)ProtocolV1ObjectTable.INSTANCE);
        marshallingConfiguration.setVersion(2);
        return marshallerFactory.createMarshaller(marshallingConfiguration);
    }

    protected Unmarshaller prepareForUnMarshalling(MarshallerFactory marshallerFactory, ClassResolver classResolver, final DataInput dataInput) throws IOException {
        Unmarshaller unmarshaller = this.getUnMarshaller(marshallerFactory, classResolver);
        InputStream is = new InputStream(){

            @Override
            public int read() throws IOException {
                try {
                    byte b = dataInput.readByte();
                    return b & 0xFF;
                }
                catch (EOFException eof) {
                    return -1;
                }
            }
        };
        ByteInput byteInput = Marshalling.createByteInput((InputStream)is);
        unmarshaller.start(byteInput);
        return unmarshaller;
    }

    private Unmarshaller getUnMarshaller(MarshallerFactory marshallerFactory, ClassResolver classResolver) throws IOException {
        MarshallingConfiguration marshallingConfiguration = new MarshallingConfiguration();
        marshallingConfiguration.setVersion(2);
        marshallingConfiguration.setClassTable((ClassTable)ProtocolV1ClassTable.INSTANCE);
        marshallingConfiguration.setObjectTable((ObjectTable)ProtocolV1ObjectTable.INSTANCE);
        marshallingConfiguration.setClassResolver(classResolver);
        return marshallerFactory.createUnmarshaller(marshallingConfiguration);
    }
}

