/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.metadata.ClassAnnotationInformation;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.entity.EntityBeanComponentDescription;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentDescription;
import org.jboss.as.ejb3.component.session.ClusteringInfo;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.component.singleton.SingletonComponentDescription;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.ejb3.annotation.Clustered;

public class ClusteredMergingProcessor
extends AbstractMergingProcessor<EJBComponentDescription> {
    public ClusteredMergingProcessor() {
        super(EJBComponentDescription.class);
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, EJBComponentDescription ejbComponentDescription) throws DeploymentUnitProcessingException {
        EEModuleClassDescription clazz = applicationClasses.getClassByName(componentClass.getName());
        if (clazz == null) {
            return;
        }
        ClassAnnotationInformation clustering = clazz.getAnnotationInformation(Clustered.class);
        if (clustering == null || clustering.getClassLevelAnnotations().isEmpty()) {
            return;
        }
        if (ejbComponentDescription instanceof MessageDrivenComponentDescription) {
            throw EjbMessages.MESSAGES.clusteredAnnotationIsNotApplicableForMDB(deploymentUnit, ejbComponentDescription.getComponentName(), ejbComponentDescription.getComponentClassName());
        }
        if (ejbComponentDescription instanceof EntityBeanComponentDescription) {
            throw EjbMessages.MESSAGES.clusteredAnnotationIsNotApplicableForEntityBean(deploymentUnit, ejbComponentDescription.getComponentName(), ejbComponentDescription.getComponentClassName());
        }
        if (ejbComponentDescription instanceof SingletonComponentDescription) {
            throw EjbMessages.MESSAGES.clusteredAnnotationNotYetImplementedForSingletonBean(deploymentUnit, ejbComponentDescription.getComponentName(), ejbComponentDescription.getComponentClassName());
        }
        if (!(ejbComponentDescription instanceof SessionBeanComponentDescription)) {
            throw EjbMessages.MESSAGES.clusteredAnnotationIsNotApplicableForBean(deploymentUnit, ejbComponentDescription.getComponentName(), ejbComponentDescription.getComponentClassName());
        }
        ClusteringInfo clusteringInfo = (ClusteringInfo)clustering.getClassLevelAnnotations().get(0);
        ((SessionBeanComponentDescription)ejbComponentDescription).setClustering(clusteringInfo);
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, EJBComponentDescription ejbComponentDescription) throws DeploymentUnitProcessingException {
    }
}

