/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.impl.factory;

import java.io.File;
import java.io.Serializable;
import org.jboss.as.ejb3.cache.Cacheable;
import org.jboss.as.ejb3.cache.PassivationManager;
import org.jboss.as.ejb3.cache.impl.backing.SimpleBackingCacheEntryStore;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntryStore;
import org.jboss.as.ejb3.cache.spi.SerializationGroup;
import org.jboss.as.ejb3.cache.spi.SerializationGroupMember;
import org.jboss.as.ejb3.cache.spi.impl.AbstractBackingCacheEntryStoreSource;
import org.jboss.as.ejb3.cache.spi.impl.FilePersistentObjectStore;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.as.server.services.path.AbstractPathService;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;

public class NonClusteredBackingCacheEntryStoreSource<K extends Serializable, V extends Cacheable<K>, G extends Serializable>
extends AbstractBackingCacheEntryStoreSource<K, V, G> {
    public static final String DEFAULT_SESSION_DIRECTORY_NAME = "ejb3" + File.separatorChar + "sessions";
    public static final String DEFAULT_GROUP_DIRECTORY_NAME = "ejb3" + File.separatorChar + "groups";
    public static final String DEFAULT_RELATIVE_TO = "jboss.server.data.dir";
    public static final int DEFAULT_SUBDIRECTORY_COUNT = 100;
    private final InjectedValue<String> relativeTo = new InjectedValue();
    private String sessionDirectoryName = DEFAULT_SESSION_DIRECTORY_NAME;
    private String groupDirectoryName = DEFAULT_GROUP_DIRECTORY_NAME;
    private String relativeToRef = "jboss.server.data.dir";
    private int subdirectoryCount = 100;

    @Override
    public <E extends SerializationGroup<K, V, G>> BackingCacheEntryStore<G, Cacheable<G>, E> createGroupIntegratedObjectStore(PassivationManager<G, E> passivationManager, StatefulTimeoutInfo timeout) {
        FilePersistentObjectStore objectStore = new FilePersistentObjectStore(passivationManager.getMarshallingConfiguration(), this.getStoragePath(null, this.groupDirectoryName), this.subdirectoryCount);
        SimpleBackingCacheEntryStore store = new SimpleBackingCacheEntryStore(objectStore, timeout, this);
        return store;
    }

    @Override
    public <E extends SerializationGroupMember<K, V, G>> BackingCacheEntryStore<K, V, E> createIntegratedObjectStore(String beanName, PassivationManager<K, E> passivationManager, StatefulTimeoutInfo timeout) {
        FilePersistentObjectStore objectStore = new FilePersistentObjectStore(passivationManager.getMarshallingConfiguration(), this.getStoragePath(beanName, this.sessionDirectoryName), this.subdirectoryCount);
        SimpleBackingCacheEntryStore store = new SimpleBackingCacheEntryStore(objectStore, timeout, this);
        return store;
    }

    @Override
    public void addDependencies(ServiceTarget target, ServiceBuilder<?> builder) {
        builder.addDependency(AbstractPathService.pathNameOf((String)this.relativeToRef), String.class, this.relativeTo);
    }

    private String getStoragePath(String beanName, String subDirectory) {
        File path;
        String relativeTo = (String)this.relativeTo.getOptionalValue();
        File file = path = relativeTo != null ? new File(new File(relativeTo), subDirectory) : new File(subDirectory);
        if (beanName != null) {
            path = new File(path, beanName);
        }
        return path.getAbsolutePath();
    }

    public String getSessionDirectoryName() {
        return this.sessionDirectoryName;
    }

    public void setSessionDirectoryName(String directoryName) {
        this.sessionDirectoryName = directoryName;
    }

    public String getGroupDirectoryName() {
        return this.groupDirectoryName;
    }

    public void setGroupDirectoryName(String groupDirectoryName) {
        this.groupDirectoryName = groupDirectoryName;
    }

    public int getSubdirectoryCount() {
        return this.subdirectoryCount;
    }

    public void setSubdirectoryCount(int subdirectoryCount) {
        this.subdirectoryCount = subdirectoryCount;
    }

    public String getRelativeTo() {
        return this.relativeToRef;
    }

    public void setRelativeTo(String relativeTo) {
        this.relativeToRef = relativeTo;
    }
}

