/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.ejb.ConcurrentAccessException;
import javax.ejb.ConcurrentAccessTimeoutException;
import javax.ejb.Timer;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.EjbComponentInstance;
import org.jboss.as.ejb3.component.pool.PooledComponent;
import org.jboss.as.ejb3.pool.Pool;
import org.jboss.as.ejb3.timerservice.spi.MultiTimeoutMethodTimedObjectInvoker;

public class PooledTimedObjectInvokerImpl
implements MultiTimeoutMethodTimedObjectInvoker,
Serializable {
    private final EJBComponent ejbComponent;
    private final Pool<EjbComponentInstance> pool;
    private final String deploymentString;

    public PooledTimedObjectInvokerImpl(EJBComponent ejbComponent, String deploymentString) {
        this.ejbComponent = ejbComponent;
        this.deploymentString = deploymentString;
        this.pool = ((PooledComponent)((Object)ejbComponent)).getPool();
    }

    @Override
    public void callTimeout(Timer timer, Method timeoutMethod) throws Exception {
        EjbComponentInstance instance = this.acquireInstance();
        boolean discarded = false;
        try {
            instance.invokeTimeoutMethod(timeoutMethod, timer);
        }
        catch (Exception ex) {
            if (this.ejbComponent.getApplicationException(ex.getClass(), timeoutMethod) != null) {
                throw ex;
            }
            if (ex instanceof ConcurrentAccessTimeoutException || ex instanceof ConcurrentAccessException) {
                throw ex;
            }
            if (ex instanceof RuntimeException || ex instanceof RemoteException) {
                discarded = true;
                if (this.pool != null) {
                    this.pool.discard(instance);
                }
            }
            throw ex;
        }
        catch (Error e) {
            discarded = true;
            if (this.pool != null) {
                this.pool.discard(instance);
            }
            throw e;
        }
        catch (Throwable t) {
            discarded = true;
            if (this.pool != null) {
                this.pool.discard(instance);
            }
            throw new RuntimeException(t);
        }
        finally {
            if (!discarded) {
                this.releaseInstance(instance);
            }
        }
    }

    private EjbComponentInstance acquireInstance() {
        EjbComponentInstance instance = this.pool != null ? this.pool.get() : (EjbComponentInstance)this.ejbComponent.createInstance();
        return instance;
    }

    @Override
    public String getTimedObjectId() {
        return this.deploymentString + "." + this.ejbComponent.getComponentName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callTimeout(Timer timer) throws Exception {
        EjbComponentInstance instance = this.acquireInstance();
        try {
            instance.invokeTimeoutMethod(timer);
        }
        finally {
            this.releaseInstance(instance);
        }
    }

    private void releaseInstance(EjbComponentInstance instance) {
        if (this.pool != null) {
            this.pool.release(instance);
        } else {
            instance.destroy();
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.ejbComponent.getComponentClass().getClassLoader();
    }
}

