/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.task;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.timerservice.CalendarTimer;
import org.jboss.as.ejb3.timerservice.TimerState;
import org.jboss.as.ejb3.timerservice.spi.MultiTimeoutMethodTimedObjectInvoker;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.as.ejb3.timerservice.task.TimerTask;

public class CalendarTimerTask
extends TimerTask<CalendarTimer> {
    public CalendarTimerTask(CalendarTimer calendarTimer) {
        super(calendarTimer);
    }

    @Override
    protected void callTimeout() throws Exception {
        CalendarTimer calendarTimer = (CalendarTimer)this.getTimer();
        if (calendarTimer.getNextExpiration() != null && !calendarTimer.isInRetry()) {
            calendarTimer.scheduleTimeout();
        }
        if (calendarTimer.isAutoTimer()) {
            TimedObjectInvoker invoker = this.timerService.getInvoker();
            if (!(invoker instanceof MultiTimeoutMethodTimedObjectInvoker)) {
                String msg = "Cannot invoke timeout method because timer: " + calendarTimer + " is an auto timer, but invoker is not of type" + MultiTimeoutMethodTimedObjectInvoker.class;
                EjbLogger.ROOT_LOGGER.failToInvokeTimeout(calendarTimer, MultiTimeoutMethodTimedObjectInvoker.class);
                throw EjbMessages.MESSAGES.failToInvokeTimeout(calendarTimer, MultiTimeoutMethodTimedObjectInvoker.class);
            }
            ((MultiTimeoutMethodTimedObjectInvoker)invoker).callTimeout(calendarTimer, calendarTimer.getTimeoutMethod());
        } else {
            this.timerService.getInvoker().callTimeout(calendarTimer);
        }
    }

    @Override
    protected Date calculateNextTimeout() {
        Date currentTimeout = ((CalendarTimer)this.getTimer()).getNextExpiration();
        if (currentTimeout == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(currentTimeout);
        Calendar nextTimeout = ((CalendarTimer)this.getTimer()).getCalendarTimeout().getNextTimeout(cal);
        if (nextTimeout != null) {
            return nextTimeout.getTime();
        }
        return null;
    }

    @Override
    protected void postTimeoutProcessing() {
        CalendarTimer calendarTimer = (CalendarTimer)this.getTimer();
        TimerState timerState = calendarTimer.getState();
        if (timerState == TimerState.IN_TIMEOUT || timerState == TimerState.RETRY_TIMEOUT) {
            if (calendarTimer.getNextExpiration() == null) {
                calendarTimer.expireTimer();
            } else {
                calendarTimer.setTimerState(TimerState.ACTIVE);
                this.timerService.persistTimer(calendarTimer);
            }
        }
    }
}

