/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.iiop;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import javax.ejb.EJBHome;
import javax.rmi.PortableRemoteObject;
import org.jacorb.ssl.SSLPolicyValue;
import org.jacorb.ssl.SSLPolicyValueHelper;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.EJBMetaDataImp;
import org.jboss.as.ejb3.component.entity.EntityBeanComponent;
import org.jboss.as.ejb3.component.stateless.StatelessSessionComponent;
import org.jboss.as.ejb3.deployment.DeploymentRepository;
import org.jboss.as.ejb3.iiop.EjbHomeCorbaServant;
import org.jboss.as.ejb3.iiop.EjbObjectCorbaServant;
import org.jboss.as.ejb3.iiop.HomeHandleImplIIOP;
import org.jboss.as.ejb3.iiop.POARegistry;
import org.jboss.as.ejb3.iiop.ReferenceFactory;
import org.jboss.as.ejb3.iiop.ServantRegistry;
import org.jboss.as.jacorb.rmi.ir.InterfaceRepository;
import org.jboss.as.jacorb.rmi.marshal.strategy.SkeletonStrategy;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.ejb.client.EJBHomeLocator;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EntityEJBLocator;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.ejb.client.StatelessEJBLocator;
import org.jboss.logging.Logger;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.marshalling.OutputStreamByteOutput;
import org.jboss.marshalling.river.RiverMarshallerFactory;
import org.jboss.metadata.ejb.jboss.IORTransportConfigMetaData;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.omg.CORBA.Any;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.Repository;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.PortableServer.Current;
import org.omg.PortableServer.CurrentHelper;
import org.omg.PortableServer.POA;

public class EjbIIOPService
implements Service<EjbIIOPService> {
    private static final Logger logger = Logger.getLogger(EjbIIOPService.class);
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"EjbIIOPService"});
    private final InjectedValue<EJBComponent> ejbComponentInjectedValue = new InjectedValue();
    private final InjectedValue<ComponentView> homeView = new InjectedValue();
    private final InjectedValue<ComponentView> remoteView = new InjectedValue();
    private final InjectedValue<POARegistry> poaRegistry = new InjectedValue();
    private final InjectedValue<NamingContextExt> corbaNamingContext = new InjectedValue();
    private final InjectedValue<DeploymentRepository> deploymentRepository = new InjectedValue();
    private final InjectedValue<ORB> orb = new InjectedValue();
    private final InjectedValue<ServiceModuleLoader> serviceModuleLoaderInjectedValue = new InjectedValue();
    private MarshallerFactory factory;
    private MarshallingConfiguration configuration;
    private EJBMetaDataImp ejbMetaData;
    private final Map<String, SkeletonStrategy> beanMethodMap;
    private final Map<String, SkeletonStrategy> homeMethodMap;
    private final String[] beanRepositoryIds;
    private final String[] homeRepositoryIds;
    private ServantRegistry homeServantRegistry;
    private ServantRegistry beanServantRegistry;
    private ReferenceFactory homeReferenceFactory;
    private ReferenceFactory beanReferenceFactory;
    private Policy csiv2Policy;
    private Policy sslPolicy;
    private EJBHome ejbHome;
    private InterfaceRepository iri;
    private final InjectedValue<POA> irPoa = new InjectedValue();
    private Current poaCurrent;
    private String name = null;

    public EjbIIOPService(Map<String, SkeletonStrategy> beanMethodMap, String[] beanRepositoryIds, Map<String, SkeletonStrategy> homeMethodMap, String[] homeRepositoryIds) {
        this.beanMethodMap = Collections.unmodifiableMap(beanMethodMap);
        this.beanRepositoryIds = beanRepositoryIds;
        this.homeMethodMap = Collections.unmodifiableMap(homeMethodMap);
        this.homeRepositoryIds = homeRepositoryIds;
    }

    public synchronized void start(StartContext startContext) throws StartException {
        try {
            RiverMarshallerFactory factory = new RiverMarshallerFactory();
            MarshallingConfiguration configuration = new MarshallingConfiguration();
            configuration.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)((ModuleLoader)this.serviceModuleLoaderInjectedValue.getValue())));
            this.configuration = configuration;
            this.factory = factory;
            boolean interfaceRepositorySupported = false;
            EJBComponent component = (EJBComponent)((java.lang.Object)this.ejbComponentInjectedValue.getValue());
            String earApplicationName = component.getEarApplicationName();
            if (component.getDistinctName() == null || component.getDistinctName().isEmpty()) {
                this.name = earApplicationName == null || earApplicationName.isEmpty() ? "" : earApplicationName + "/";
                this.name = this.name + component.getModuleName() + "/" + component.getComponentName();
            } else {
                this.name = earApplicationName == null || earApplicationName.isEmpty() ? "" : earApplicationName + "/";
                this.name = this.name + component.getModuleName() + "/" + component.getDistinctName() + "/" + component.getComponentName();
            }
            this.name = this.name.replace(".", "_");
            ORB orb = (ORB)this.orb.getValue();
            Any secPolicy = orb.create_any();
            Serializable securityConfig = null;
            secPolicy.insert_Value(securityConfig);
            this.csiv2Policy = null;
            boolean sslRequired = false;
            if (securityConfig != null) {
                IORTransportConfigMetaData tc = securityConfig.getTransportConfig();
                sslRequired = tc.getIntegrity() == "REQUIRED" || tc.getConfidentiality() == "REQUIRED" || tc.getEstablishTrustInClient() == "REQUIRED";
            }
            Any sslPolicyValue = orb.create_any();
            SSLPolicyValueHelper.insert((Any)sslPolicyValue, (SSLPolicyValue)(sslRequired ? SSLPolicyValue.SSL_REQUIRED : SSLPolicyValue.SSL_NOT_REQUIRED));
            this.sslPolicy = null;
            logger.debug((java.lang.Object)("container's SSL policy: " + this.sslPolicy));
            this.poaCurrent = CurrentHelper.narrow((Object)orb.resolve_initial_references("POACurrent"));
            Policy[] policies = new Policy[]{};
            InterfaceDef homeInterfaceDef = null;
            if (this.iri != null) {
                Repository ir = this.iri.getReference();
                homeInterfaceDef = InterfaceDefHelper.narrow((Object)ir.lookup_id(this.homeRepositoryIds[0]));
            }
            this.homeServantRegistry = ((POARegistry)this.poaRegistry.getValue()).getRegistryWithPersistentPOAPerServant();
            EjbHomeCorbaServant homeServant = new EjbHomeCorbaServant(this.homeMethodMap, this.homeRepositoryIds, homeInterfaceDef, orb, (ComponentView)this.homeView.getValue(), (DeploymentRepository)this.deploymentRepository.getValue(), component.getTransactionManager());
            this.homeReferenceFactory = this.homeServantRegistry.bind(EjbIIOPService.homeServantName(this.name), homeServant, policies);
            Object corbaRef = this.homeReferenceFactory.createReference(this.homeRepositoryIds[0]);
            this.ejbHome = (EJBHome)PortableRemoteObject.narrow((java.lang.Object)corbaRef, EJBHome.class);
            homeServant.setHomeHandle(new HomeHandleImplIIOP(corbaRef));
            if (component instanceof EntityBeanComponent) {
                this.beanServantRegistry = ((POARegistry)this.poaRegistry.getValue()).getRegistryWithPersistentPOAPerServant();
                EntityBeanComponent entityBeanComponent = (EntityBeanComponent)component;
                Class<java.lang.Object> pkClass = entityBeanComponent.getPrimaryKeyClass();
                this.ejbMetaData = new EJBMetaDataImp(entityBeanComponent.getRemoteClass(), entityBeanComponent.getHomeClass(), pkClass, false, false, this.ejbHome);
            } else {
                this.beanServantRegistry = ((POARegistry)this.poaRegistry.getValue()).getRegistryWithTransientPOAPerServant();
                this.ejbMetaData = component instanceof StatelessSessionComponent ? new EJBMetaDataImp(((ComponentView)this.remoteView.getValue()).getViewClass(), ((ComponentView)this.homeView.getValue()).getViewClass(), null, true, true, this.ejbHome) : new EJBMetaDataImp(((ComponentView)this.remoteView.getValue()).getViewClass(), ((ComponentView)this.homeView.getValue()).getViewClass(), null, true, false, this.ejbHome);
            }
            InterfaceDef beanInterfaceDef = null;
            if (this.iri != null) {
                Repository ir = this.iri.getReference();
                beanInterfaceDef = InterfaceDefHelper.narrow((Object)ir.lookup_id(this.beanRepositoryIds[0]));
            }
            EjbObjectCorbaServant beanServant = new EjbObjectCorbaServant(this.poaCurrent, this.beanMethodMap, this.beanRepositoryIds, beanInterfaceDef, orb, (ComponentView)this.remoteView.getValue(), (MarshallerFactory)factory, configuration, component.getTransactionManager());
            this.beanReferenceFactory = this.beanServantRegistry.bind(EjbIIOPService.beanServantName(this.name), beanServant, policies);
            NamingContextExt corbaContext = (NamingContextExt)this.corbaNamingContext.getValue();
            EjbIIOPService.rebind(corbaContext, this.name, corbaRef);
            logger.debug((java.lang.Object)("Home IOR for " + component.getComponentName() + " bound to " + this.name + " in CORBA naming service"));
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        NamingContextExt corbaContext = (NamingContextExt)this.corbaNamingContext.getValue();
        try {
            NameComponent[] name = corbaContext.to_name(this.name);
            corbaContext.unbind(name);
        }
        catch (InvalidName invalidName) {
            logger.error((java.lang.Object)"Cannot unregister EJBHome from CORBA naming service", (Throwable)invalidName);
        }
        catch (NotFound notFound) {
            logger.error((java.lang.Object)"Cannot unregister EJBHome from CORBA naming service", (Throwable)notFound);
        }
        catch (CannotProceed cannotProceed) {
            logger.error((java.lang.Object)"Cannot unregister EJBHome from CORBA naming service", (Throwable)cannotProceed);
        }
        try {
            this.homeServantRegistry.unbind(EjbIIOPService.homeServantName(this.name));
        }
        catch (Exception e) {
            logger.error((java.lang.Object)"Cannot deactivate home servant", (Throwable)e);
        }
        try {
            this.beanServantRegistry.unbind(EjbIIOPService.beanServantName(this.name));
        }
        catch (Exception e) {
            logger.error((java.lang.Object)"Cannot deactivate bean servant", (Throwable)e);
        }
        if (this.iri != null) {
            this.iri.shutdown();
        }
        this.name = null;
    }

    public java.lang.Object referenceForLocator(EJBLocator<? extends java.lang.Object> locator) {
        EJBComponent ejbComponent = (EJBComponent)((java.lang.Object)this.ejbComponentInjectedValue.getValue());
        try {
            String earApplicationName;
            String string = earApplicationName = ejbComponent.getEarApplicationName() == null ? "" : ejbComponent.getEarApplicationName();
            if (locator.getBeanName().equals(ejbComponent.getComponentName()) && locator.getAppName().equals(earApplicationName) && locator.getModuleName().equals(ejbComponent.getModuleName()) && locator.getDistinctName().equals(ejbComponent.getDistinctName())) {
                if (locator instanceof EJBHomeLocator) {
                    return this.ejbHome;
                }
                if (locator instanceof StatelessEJBLocator) {
                    return this.beanReferenceFactory.createReference(this.beanRepositoryIds[0]);
                }
                if (locator instanceof StatefulEJBLocator) {
                    Marshaller marshaller = this.factory.createMarshaller(this.configuration);
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    marshaller.start((ByteOutput)new OutputStreamByteOutput((OutputStream)stream));
                    marshaller.writeObject((java.lang.Object)((StatefulEJBLocator)locator).getSessionId());
                    marshaller.finish();
                    return this.beanReferenceFactory.createReferenceWithId(stream.toByteArray(), this.beanRepositoryIds[0]);
                }
                if (locator instanceof EntityEJBLocator) {
                    Marshaller marshaller = this.factory.createMarshaller(this.configuration);
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    marshaller.start((ByteOutput)new OutputStreamByteOutput((OutputStream)stream));
                    marshaller.writeObject(((EntityEJBLocator)locator).getPrimaryKey());
                    marshaller.finish();
                    return this.beanReferenceFactory.createReferenceWithId(stream.toByteArray(), this.beanRepositoryIds[0]);
                }
                throw new RuntimeException("Unkown locator type " + locator);
            }
            throw new IllegalArgumentException("Provided locator " + locator + " was not for EJB " + (java.lang.Object)((java.lang.Object)ejbComponent));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create CORBA Object for " + locator + " for EJB " + (java.lang.Object)((java.lang.Object)ejbComponent), e);
        }
    }

    public static synchronized void rebind(NamingContextExt ctx, String strName, Object obj) throws Exception {
        NameComponent[] name = ctx.to_name(strName);
        NamingContextExt intermediateCtx = ctx;
        for (int i = 0; i < name.length - 1; ++i) {
            NameComponent[] relativeName = new NameComponent[]{name[i]};
            try {
                intermediateCtx = NamingContextHelper.narrow((Object)intermediateCtx.resolve(relativeName));
                continue;
            }
            catch (NotFound e) {
                intermediateCtx = intermediateCtx.bind_new_context(relativeName);
            }
        }
        intermediateCtx.rebind(new NameComponent[]{name[name.length - 1]}, obj);
    }

    private static String homeServantName(String jndiName) {
        return jndiName + "/home";
    }

    private static String beanServantName(String jndiName) {
        return jndiName + "/remote";
    }

    public EjbIIOPService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<ComponentView> getRemoteView() {
        return this.remoteView;
    }

    public InjectedValue<ComponentView> getHomeView() {
        return this.homeView;
    }

    public InjectedValue<EJBComponent> getEjbComponentInjectedValue() {
        return this.ejbComponentInjectedValue;
    }

    public InjectedValue<ORB> getOrb() {
        return this.orb;
    }

    public InjectedValue<NamingContextExt> getCorbaNamingContext() {
        return this.corbaNamingContext;
    }

    public InjectedValue<POARegistry> getPoaRegistry() {
        return this.poaRegistry;
    }

    public InjectedValue<POA> getIrPoa() {
        return this.irPoa;
    }

    public InjectedValue<DeploymentRepository> getDeploymentRepository() {
        return this.deploymentRepository;
    }

    public InjectedValue<ServiceModuleLoader> getServiceModuleLoaderInjectedValue() {
        return this.serviceModuleLoaderInjectedValue;
    }
}

