/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.util.Map;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.ViewInstanceFactory;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.ejb.client.EJBClient;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class StatefulRemoteViewInstanceFactory
implements ViewInstanceFactory {
    private final String applicationName;
    private final String moduleName;
    private final String distinctName;
    private final String beanName;

    public StatefulRemoteViewInstanceFactory(String applicationName, String moduleName, String distinctName, String beanName) {
        this.applicationName = applicationName == null ? "" : applicationName;
        this.moduleName = moduleName;
        this.distinctName = distinctName;
        this.beanName = beanName;
    }

    public ManagedReference createViewInstance(ComponentView componentView, Map<Object, Object> contextData) {
        SessionID sessionID = (SessionID)contextData.get(SessionID.SESSION_ID_KEY);
        if (sessionID == null) {
            try {
                sessionID = EJBClient.createSession((String)this.applicationName, (String)this.moduleName, (String)this.beanName, (String)this.distinctName);
            }
            catch (Exception e) {
                throw EjbMessages.MESSAGES.failToCreateStatefulSessionBean(this.beanName, e);
            }
        }
        Object value = EJBClient.createProxy((EJBLocator)new StatefulEJBLocator(componentView.getViewClass(), this.applicationName, this.moduleName, this.beanName, this.distinctName, sessionID));
        return new ValueManagedReference((Value)new ImmediateValue(value));
    }
}

