/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.messagedriven;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.ejb.TransactionAttributeType;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.TransactionManager;
import org.jboss.as.ee.component.BasicComponentInstance;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentCreateService;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentInstance;
import org.jboss.as.ejb3.component.pool.PoolConfig;
import org.jboss.as.ejb3.component.pool.PooledComponent;
import org.jboss.as.ejb3.inflow.JBossMessageEndpointFactory;
import org.jboss.as.ejb3.inflow.MessageEndpointService;
import org.jboss.as.ejb3.pool.Pool;
import org.jboss.as.ejb3.pool.StatelessObjectFactory;
import org.jboss.as.ejb3.timerservice.PooledTimedObjectInvokerImpl;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.as.naming.ManagedReference;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.msc.service.StopContext;

public class MessageDrivenComponent
extends EJBComponent
implements PooledComponent<MessageDrivenComponentInstance> {
    private final Pool<MessageDrivenComponentInstance> pool;
    private final ActivationSpec activationSpec;
    private final MessageEndpointFactory endpointFactory;
    private final Class<?> messageListenerInterface;
    private ResourceAdapter resourceAdapter;
    private final TimedObjectInvoker timedObjectInvoker;

    protected MessageDrivenComponent(MessageDrivenComponentCreateService ejbComponentCreateService, final Class<?> messageListenerInterface, ActivationSpec activationSpec) {
        super(ejbComponentCreateService);
        StatelessObjectFactory<MessageDrivenComponentInstance> factory = new StatelessObjectFactory<MessageDrivenComponentInstance>(){

            @Override
            public MessageDrivenComponentInstance create() {
                return (MessageDrivenComponentInstance)MessageDrivenComponent.this.createInstance();
            }

            @Override
            public void destroy(MessageDrivenComponentInstance obj) {
                obj.destroy();
            }
        };
        PoolConfig poolConfig = ejbComponentCreateService.getPoolConfig();
        if (poolConfig == null) {
            EjbLogger.ROOT_LOGGER.debug("Pooling is disabled for MDB " + ejbComponentCreateService.getComponentName());
            this.pool = null;
        } else {
            EjbLogger.ROOT_LOGGER.debug("Using pool config " + poolConfig + " to create pool for MDB " + ejbComponentCreateService.getComponentName());
            this.pool = poolConfig.createPool(factory);
        }
        this.activationSpec = activationSpec;
        this.messageListenerInterface = messageListenerInterface;
        MessageEndpointService<Object> service = new MessageEndpointService<Object>(){

            @Override
            public Class<Object> getMessageListenerInterface() {
                return messageListenerInterface;
            }

            @Override
            public TransactionManager getTransactionManager() {
                return MessageDrivenComponent.this.getTransactionManager();
            }

            @Override
            public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException {
                return MessageDrivenComponent.this.getTransactionAttributeType(MethodIntf.BEAN, method) == TransactionAttributeType.REQUIRED;
            }

            @Override
            public Object obtain(long timeout, TimeUnit unit) {
                return MessageDrivenComponent.this.createViewInstanceProxy(messageListenerInterface, Collections.emptyMap());
            }

            @Override
            public void release(Object obj) {
            }
        };
        this.endpointFactory = new JBossMessageEndpointFactory(this.getComponentClass().getClassLoader(), service);
        String deploymentName = ejbComponentCreateService.getDistinctName() == null || ejbComponentCreateService.getDistinctName().length() == 0 ? ejbComponentCreateService.getApplicationName() + "." + ejbComponentCreateService.getModuleName() : ejbComponentCreateService.getApplicationName() + "." + ejbComponentCreateService.getModuleName() + "." + ejbComponentCreateService.getDistinctName();
        this.timedObjectInvoker = new PooledTimedObjectInvokerImpl(this, deploymentName);
    }

    protected BasicComponentInstance instantiateComponentInstance(AtomicReference<ManagedReference> instanceReference, Interceptor preDestroyInterceptor, Map<Method, Interceptor> methodInterceptors, InterceptorFactoryContext interceptorContext) {
        Map<Method, Interceptor> timeouts;
        if (this.timeoutInterceptors != null) {
            timeouts = new HashMap();
            for (Map.Entry entry : this.timeoutInterceptors.entrySet()) {
                timeouts.put((Method)entry.getKey(), ((InterceptorFactory)entry.getValue()).create(interceptorContext));
            }
        } else {
            timeouts = Collections.emptyMap();
        }
        return new MessageDrivenComponentInstance(this, instanceReference, preDestroyInterceptor, methodInterceptors, timeouts);
    }

    @Override
    public Pool<MessageDrivenComponentInstance> getPool() {
        return this.pool;
    }

    protected void setResourceAdapter(ResourceAdapter resourceAdapter) {
        this.resourceAdapter = resourceAdapter;
    }

    public void start() {
        if (this.resourceAdapter == null) {
            throw EjbMessages.MESSAGES.resourceAdapterNotSpecified(this);
        }
        super.start();
        try {
            this.resourceAdapter.endpointActivation(this.endpointFactory, this.activationSpec);
        }
        catch (ResourceException e) {
            throw new RuntimeException(e);
        }
    }

    public void stop(StopContext stopContext) {
        this.resourceAdapter.endpointDeactivation(this.endpointFactory, this.activationSpec);
        super.stop(stopContext);
    }

    @Override
    public TimedObjectInvoker getTimedObjectInvoker() {
        return this.timedObjectInvoker;
    }
}

