/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagementType;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ee.component.BasicComponentCreateService;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBComponentCreateService;
import org.jboss.as.ejb3.component.EJBUtilities;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.MethodTransactionAttributeKey;
import org.jboss.as.ejb3.context.CurrentInvocationContext;
import org.jboss.as.ejb3.remote.EJBRemoteTransactionsRepository;
import org.jboss.as.ejb3.security.EJBSecurityMetaData;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.as.ejb3.tx.ApplicationExceptionDetails;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.as.security.service.SimpleSecurityManager;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.ejb.client.EJBClient;
import org.jboss.ejb.client.EJBHomeLocator;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public abstract class EJBComponent
extends BasicComponent {
    private static final Logger log = Logger.getLogger(EJBComponent.class);
    private static final ApplicationExceptionDetails APPLICATION_EXCEPTION = new ApplicationExceptionDetails("java.lang.Exception", true, false);
    private final Map<MethodTransactionAttributeKey, TransactionAttributeType> txAttrs;
    private final EJBUtilities utilities;
    private final boolean isBeanManagedTransaction;
    private final Map<Class<?>, ApplicationExceptionDetails> applicationExceptions;
    private final EJBSecurityMetaData securityMetaData;
    private final Map<String, ServiceName> viewServices;
    private final ServiceName ejbLocalHome;
    private final ServiceName ejbHome;
    private final ServiceName ejbObject;
    private final ServiceName ejbLocalObject;
    private final TimerService timerService;
    protected final Map<Method, InterceptorFactory> timeoutInterceptors;
    private final Method timeoutMethod;
    private final String applicationName;
    private final String earApplicationName;
    private final String moduleName;
    private final String distinctName;
    private final EJBRemoteTransactionsRepository ejbRemoteTransactionsRepository;

    protected EJBComponent(EJBComponentCreateService ejbComponentCreateService) {
        super((BasicComponentCreateService)ejbComponentCreateService);
        this.applicationExceptions = Collections.unmodifiableMap(ejbComponentCreateService.getApplicationExceptions().getApplicationExceptions());
        this.utilities = ejbComponentCreateService.getEJBUtilities();
        Map<MethodTransactionAttributeKey, TransactionAttributeType> txAttrs = ejbComponentCreateService.getTxAttrs();
        this.txAttrs = txAttrs == null || txAttrs.isEmpty() ? Collections.emptyMap() : txAttrs;
        this.isBeanManagedTransaction = TransactionManagementType.BEAN.equals((Object)ejbComponentCreateService.getTransactionManagementType());
        this.securityMetaData = ejbComponentCreateService.getSecurityMetaData();
        this.viewServices = ejbComponentCreateService.getViewServices();
        this.timerService = ejbComponentCreateService.getTimerService();
        this.timeoutInterceptors = ejbComponentCreateService.getTimeoutInterceptors();
        this.timeoutMethod = ejbComponentCreateService.getTimeoutMethod();
        this.ejbLocalHome = ejbComponentCreateService.getEjbLocalHome();
        this.ejbHome = ejbComponentCreateService.getEjbHome();
        this.applicationName = ejbComponentCreateService.getApplicationName();
        this.earApplicationName = ejbComponentCreateService.getEarApplicationName();
        this.distinctName = ejbComponentCreateService.getDistinctName();
        this.moduleName = ejbComponentCreateService.getModuleName();
        this.ejbObject = ejbComponentCreateService.getEjbObject();
        this.ejbLocalObject = ejbComponentCreateService.getEjbLocalObject();
        this.ejbRemoteTransactionsRepository = ejbComponentCreateService.getEJBRemoteTransactionsRepository();
    }

    protected <T> T createViewInstanceProxy(Class<T> viewInterface, Map<Object, Object> contextData) {
        if (viewInterface == null) {
            throw new IllegalArgumentException("View interface is null");
        }
        if (this.viewServices.containsKey(viewInterface.getName())) {
            ServiceName serviceName = this.viewServices.get(viewInterface.getName());
            return this.createViewInstanceProxy(viewInterface, contextData, serviceName);
        }
        throw new IllegalStateException("View of type " + viewInterface + " not found on bean " + (Object)((Object)this));
    }

    protected <T> T createViewInstanceProxy(Class<T> viewInterface, Map<Object, Object> contextData, ServiceName serviceName) {
        ServiceController serviceController = CurrentServiceContainer.getServiceContainer().getRequiredService(serviceName);
        ComponentView view = (ComponentView)serviceController.getValue();
        ManagedReference instance = view.createInstance(contextData);
        return viewInterface.cast(instance.getInstance());
    }

    public ApplicationExceptionDetails getApplicationException(Class<?> exceptionClass, Method invokedMethod) {
        ApplicationExceptionDetails applicationException = this.applicationExceptions.get(exceptionClass);
        if (applicationException != null) {
            return applicationException;
        }
        for (Class<?> superClass = exceptionClass.getSuperclass(); superClass != null && !superClass.equals(Exception.class) && !superClass.equals(Object.class); superClass = superClass.getSuperclass()) {
            applicationException = this.applicationExceptions.get(superClass);
            if (applicationException == null) continue;
            if (applicationException.isInherited()) {
                return applicationException;
            }
            return null;
        }
        if (RuntimeException.class.isAssignableFrom(exceptionClass) || Error.class.isAssignableFrom(exceptionClass)) {
            return null;
        }
        if (invokedMethod != null) {
            Class<?>[] exceptionTypes;
            for (Class<?> type : exceptionTypes = invokedMethod.getExceptionTypes()) {
                if (!type.isAssignableFrom(exceptionClass)) continue;
                return APPLICATION_EXCEPTION;
            }
        }
        return null;
    }

    public Principal getCallerPrincipal() {
        return this.utilities.getSecurityManager().getCallerPrincipal();
    }

    protected TransactionAttributeType getCurrentTransactionAttribute() {
        InterceptorContext invocation = CurrentInvocationContext.get();
        MethodIntf methodIntf = (MethodIntf)((Object)invocation.getPrivateData(MethodIntf.class));
        if (methodIntf == null) {
            ComponentView componentView = (ComponentView)invocation.getPrivateData(ComponentView.class);
            methodIntf = componentView != null ? (MethodIntf)((Object)componentView.getPrivateData(MethodIntf.class)) : MethodIntf.BEAN;
        }
        return this.getTransactionAttributeType(methodIntf, invocation.getMethod());
    }

    public EJBHome getEJBHome() throws IllegalStateException {
        if (this.ejbHome == null) {
            throw EjbMessages.MESSAGES.beanHomeInterfaceIsNull(this.getComponentName());
        }
        ServiceController serviceController = CurrentServiceContainer.getServiceContainer().getRequiredService(this.ejbHome);
        ComponentView view = (ComponentView)serviceController.getValue();
        String locatorAppName = this.earApplicationName == null ? "" : this.earApplicationName;
        return (EJBHome)EJBClient.createProxy((EJBLocator)new EJBHomeLocator(view.getViewClass(), locatorAppName, this.moduleName, this.getComponentName(), this.distinctName));
    }

    public Class<?> getEjbObjectType() {
        if (this.ejbObject == null) {
            return null;
        }
        ServiceController serviceController = CurrentServiceContainer.getServiceContainer().getRequiredService(this.ejbObject);
        ComponentView view = (ComponentView)serviceController.getValue();
        return view.getViewClass();
    }

    public Class<?> getEjbLocalObjectType() {
        if (this.ejbLocalObject == null) {
            return null;
        }
        ServiceController serviceController = CurrentServiceContainer.getServiceContainer().getRequiredService(this.ejbLocalObject);
        ComponentView view = (ComponentView)serviceController.getValue();
        return view.getViewClass();
    }

    public EJBLocalHome getEJBLocalHome() throws IllegalStateException {
        if (this.ejbLocalHome == null) {
            throw EjbMessages.MESSAGES.beanLocalHomeInterfaceIsNull(this.getComponentName());
        }
        return this.createViewInstanceProxy(EJBLocalHome.class, Collections.<Object, Object>emptyMap(), this.ejbLocalHome);
    }

    public boolean getRollbackOnly() throws IllegalStateException {
        if (this.isBeanManagedTransaction()) {
            throw EjbMessages.MESSAGES.failToCallgetRollbackOnly();
        }
        try {
            TransactionManager tm = this.getTransactionManager();
            if (tm.getTransaction() == null) {
                throw EjbMessages.MESSAGES.failToCallgetRollbackOnlyOnNoneTransaction();
            }
            int status = tm.getStatus();
            if (log.isTraceEnabled()) {
                EjbLogger.ROOT_LOGGER.trace("Current transaction status is " + status);
            }
            switch (status) {
                case 3: 
                case 4: {
                    throw EjbMessages.MESSAGES.failToCallgetRollbackOnlyAfterTxcompleted();
                }
                case 1: 
                case 9: {
                    return true;
                }
            }
            return false;
        }
        catch (SystemException se) {
            EjbLogger.ROOT_LOGGER.getTxManagerStatusFailed(se);
            return true;
        }
    }

    public SimpleSecurityManager getSecurityManager() {
        return this.utilities.getSecurityManager();
    }

    public TimerService getTimerService() throws IllegalStateException {
        return this.timerService;
    }

    public TransactionAttributeType getTransactionAttributeType(MethodIntf methodIntf, Method method) {
        TransactionAttributeType txAttr = this.txAttrs.get(new MethodTransactionAttributeKey(methodIntf, MethodIdentifier.getIdentifierForMethod((Method)method)));
        if (txAttr == null && methodIntf != MethodIntf.BEAN) {
            txAttr = this.txAttrs.get(new MethodTransactionAttributeKey(MethodIntf.BEAN, MethodIdentifier.getIdentifierForMethod((Method)method)));
        }
        if (txAttr == null) {
            return TransactionAttributeType.REQUIRED;
        }
        return txAttr;
    }

    public TransactionManager getTransactionManager() {
        return this.utilities.getTransactionManager();
    }

    public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return this.utilities.getTransactionSynchronizationRegistry();
    }

    public int getTransactionTimeout(Method method) {
        return -1;
    }

    public UserTransaction getUserTransaction() throws IllegalStateException {
        if (!this.isBeanManagedTransaction()) {
            throw EjbMessages.MESSAGES.failToCallIsBeanManagedTransaction();
        }
        return this.utilities.getUserTransaction();
    }

    private boolean isBeanManagedTransaction() {
        return this.isBeanManagedTransaction;
    }

    public boolean isCallerInRole(String roleName) throws IllegalStateException {
        return this.utilities.getSecurityManager().isCallerInRole(this.securityMetaData.getSecurityRoles(), new String[]{roleName});
    }

    public Object lookup(String name) throws IllegalArgumentException {
        if (name == null) {
            throw EjbMessages.MESSAGES.jndiNameCannotBeNull();
        }
        NamespaceContextSelector namespaceContextSelector = NamespaceContextSelector.getCurrentSelector();
        if (namespaceContextSelector == null) {
            throw EjbMessages.MESSAGES.noNamespaceContextSelectorAvailable(name);
        }
        Context jndiContext = null;
        String namespaceStrippedJndiName = name;
        if (name.startsWith("java:app/")) {
            jndiContext = namespaceContextSelector.getContext("app");
            namespaceStrippedJndiName = name.substring("java:app/".length());
        } else if (name.startsWith("java:module/")) {
            jndiContext = namespaceContextSelector.getContext("module");
            namespaceStrippedJndiName = name.substring("java:module/".length());
        } else if (name.startsWith("java:comp/")) {
            jndiContext = namespaceContextSelector.getContext("comp");
            namespaceStrippedJndiName = name.substring("java:comp/".length());
        } else if (!name.startsWith("java:")) {
            jndiContext = namespaceContextSelector.getContext("comp");
            namespaceStrippedJndiName = "env/" + name;
        } else if (name.startsWith("java:global/")) {
            try {
                jndiContext = new InitialContext();
            }
            catch (NamingException ne) {
                throw EjbMessages.MESSAGES.failToLookupJNDI(name, ne);
            }
        } else {
            throw EjbMessages.MESSAGES.failToLookupJNDINameSpace(name);
        }
        EjbLogger.ROOT_LOGGER.debug("Looking up " + namespaceStrippedJndiName + " in jndi context: " + jndiContext);
        try {
            return jndiContext.lookup(namespaceStrippedJndiName);
        }
        catch (NamingException ne) {
            throw EjbMessages.MESSAGES.failToLookupStrippedJNDI(namespaceContextSelector, jndiContext, ne);
        }
    }

    public void setRollbackOnly() throws IllegalStateException {
        if (this.isBeanManagedTransaction()) {
            throw EjbMessages.MESSAGES.failToCallSetRollbackOnlyOnNoneCMB();
        }
        try {
            TransactionManager tm = this.getTransactionManager();
            if (tm.getTransaction() == null) {
                throw EjbMessages.MESSAGES.failToCallSetRollbackOnlyWithNoTx();
            }
            tm.setRollbackOnly();
        }
        catch (SystemException se) {
            EjbLogger.ROOT_LOGGER.setRollbackOnlyFailed(se);
        }
    }

    public EJBSecurityMetaData getSecurityMetaData() {
        return this.securityMetaData;
    }

    public TimedObjectInvoker getTimedObjectInvoker() {
        return null;
    }

    public Method getTimeoutMethod() {
        return this.timeoutMethod;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getEarApplicationName() {
        return this.earApplicationName;
    }

    public String getDistinctName() {
        return this.distinctName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public EJBRemoteTransactionsRepository getEjbRemoteTransactionsRepository() {
        return this.ejbRemoteTransactionsRepository;
    }
}

