/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.MethodIntf;

public class EJBBusinessMethod
implements Serializable {
    private final String methodName;
    private final Class<?>[] methodParamTypes;
    private final MethodIntf viewType;
    private final int hashCode;

    public EJBBusinessMethod(Method method) {
        this(method.getName(), method.getParameterTypes());
    }

    public EJBBusinessMethod(String methodName, Class<?> ... methodParamTypes) {
        this(MethodIntf.BEAN, methodName, methodParamTypes);
    }

    public EJBBusinessMethod(MethodIntf view, String methodName, Class<?> ... paramTypes) {
        if (methodName == null) {
            throw EjbMessages.MESSAGES.methodeNameIsNull();
        }
        this.methodName = methodName;
        this.methodParamTypes = paramTypes == null ? new Class[]{} : paramTypes;
        this.viewType = view == null ? MethodIntf.BEAN : view;
        this.hashCode = this.generateHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EJBBusinessMethod that = (EJBBusinessMethod)o;
        if (!this.methodName.equals(that.methodName)) {
            return false;
        }
        if (!Arrays.equals(this.methodParamTypes, that.methodParamTypes)) {
            return false;
        }
        return this.viewType == that.viewType;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int generateHashCode() {
        int result = this.methodName.hashCode();
        result = 31 * result + Arrays.hashCode(this.methodParamTypes);
        result = 31 * result + this.viewType.hashCode();
        return result;
    }
}

