/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice;

import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.ejb3.timerservice.mk2.TimerServiceFactoryImpl;
import org.jboss.as.ejb3.timerservice.mk2.persistence.filestore.FileTimerPersistence;
import org.jboss.as.ejb3.timerservice.spi.TimerServiceFactory;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class TimerServiceFactoryService
implements Service<TimerServiceFactory> {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"ejb", "timerServiceFactory"});
    public static final ServiceName PATH_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"as", "ejb", "timerServiceFactory", "dataStorePath"});
    private volatile TimerServiceFactory timerServiceFactory;
    private volatile ExecutorService executorService;
    private volatile FileTimerPersistence timerPersistence;
    private final InjectedValue<TransactionManager> transactionManagerInjectedValue = new InjectedValue();
    private final InjectedValue<TransactionSynchronizationRegistry> transactionSynchronizationRegistryInjectedValue = new InjectedValue();
    private final InjectedValue<String> path = new InjectedValue();
    private final int maxThreads;
    private final int coreThreads;
    private final String name;
    private final Module module;

    public TimerServiceFactoryService(int coreThreads, int maxThreads, String name, Module module) {
        this.name = name;
        this.coreThreads = coreThreads;
        this.maxThreads = maxThreads;
        this.module = module;
    }

    public void start(StartContext context) throws StartException {
        this.executorService = new ThreadPoolExecutor(this.coreThreads, this.maxThreads, 1L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>());
        String path = (String)this.path.getOptionalValue();
        if (path != null) {
            this.timerPersistence = new FileTimerPersistence((TransactionManager)this.transactionManagerInjectedValue.getValue(), (TransactionSynchronizationRegistry)this.transactionSynchronizationRegistryInjectedValue.getValue(), new File(path + File.separatorChar + this.name), true, this.module.getModuleLoader());
            this.timerPersistence.start();
        }
        this.timerServiceFactory = new TimerServiceFactoryImpl(this.timerPersistence, (TransactionManager)this.transactionManagerInjectedValue.getValue(), this.executorService);
    }

    public void stop(StopContext context) {
        this.executorService.shutdownNow();
        if (this.path == null) {
            this.timerPersistence.stop();
            this.timerPersistence = null;
        }
        this.timerServiceFactory = null;
        this.executorService = null;
    }

    public TimerServiceFactory getValue() throws IllegalStateException, IllegalArgumentException {
        return this.timerServiceFactory;
    }

    public TimerServiceFactory getTimerServiceFactory() {
        return this.timerServiceFactory;
    }

    public InjectedValue<TransactionManager> getTransactionManagerInjectedValue() {
        return this.transactionManagerInjectedValue;
    }

    public InjectedValue<TransactionSynchronizationRegistry> getTransactionSynchronizationRegistryInjectedValue() {
        return this.transactionSynchronizationRegistryInjectedValue;
    }

    public InjectedValue<String> getPath() {
        return this.path;
    }
}

