/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.metadata.ClassAnnotationInformation;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.ejb3.annotation.SecurityDomain;
import org.jboss.logging.Logger;

public class SecurityDomainMergingProcessor
extends AbstractMergingProcessor<EJBComponentDescription> {
    private static final Logger logger = Logger.getLogger(SecurityDomainMergingProcessor.class);

    public SecurityDomainMergingProcessor() {
        super(EJBComponentDescription.class);
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, EJBComponentDescription description) throws DeploymentUnitProcessingException {
        EEModuleClassDescription clazz = applicationClasses.getClassByName(componentClass.getName());
        if (clazz == null) {
            return;
        }
        ClassAnnotationInformation securityDomain = clazz.getAnnotationInformation(SecurityDomain.class);
        if (securityDomain == null) {
            return;
        }
        if (!securityDomain.getClassLevelAnnotations().isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("EJB " + description.getEJBName() + " is part of security domain " + (String)securityDomain.getClassLevelAnnotations().get(0)));
            }
            description.setSecurityDomain((String)securityDomain.getClassLevelAnnotations().get(0));
        }
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, EJBComponentDescription description) throws DeploymentUnitProcessingException {
    }
}

