/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import java.util.Set;
import javax.ejb.DependsOn;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEApplicationDescription;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.metadata.ClassAnnotationInformation;
import org.jboss.as.ejb3.component.singleton.SingletonComponentDescription;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.spec.SessionBean31MetaData;
import org.jboss.msc.service.ServiceBuilder;

public class EjbDependsOnMergingProcessor
extends AbstractMergingProcessor<SingletonComponentDescription> {
    private static final Logger logger = Logger.getLogger(EjbDependsOnMergingProcessor.class);

    public EjbDependsOnMergingProcessor() {
        super(SingletonComponentDescription.class);
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, SingletonComponentDescription description) throws DeploymentUnitProcessingException {
        EEModuleClassDescription classDescription = applicationClasses.getClassByName(componentClass.getName());
        EEApplicationDescription applicationDescription = (EEApplicationDescription)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_DESCRIPTION);
        ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT);
        ClassAnnotationInformation dependsOnClassAnnotationInformation = classDescription.getAnnotationInformation(DependsOn.class);
        if (dependsOnClassAnnotationInformation != null && !dependsOnClassAnnotationInformation.getClassLevelAnnotations().isEmpty()) {
            String[] annotationValues = (String[])dependsOnClassAnnotationInformation.getClassLevelAnnotations().get(0);
            this.setupDependencies(description, applicationDescription, deploymentRoot, annotationValues);
        }
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, SingletonComponentDescription description) throws DeploymentUnitProcessingException {
        SessionBean31MetaData metaData;
        EEApplicationDescription applicationDescription = (EEApplicationDescription)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_DESCRIPTION);
        ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT);
        if (description.getDescriptorData() instanceof SessionBean31MetaData && (metaData = (SessionBean31MetaData)description.getDescriptorData()).getDependsOn() != null) {
            this.setupDependencies(description, applicationDescription, deploymentRoot, metaData.getDependsOn());
        }
    }

    private void setupDependencies(SingletonComponentDescription description, EEApplicationDescription applicationDescription, ResourceRoot deploymentRoot, String[] annotationValues) throws DeploymentUnitProcessingException {
        for (String annotationValue : annotationValues) {
            Set components = applicationDescription.getComponents(annotationValue, deploymentRoot.getRoot());
            if (components.isEmpty()) {
                throw new DeploymentUnitProcessingException("Could not find EJB " + annotationValue + " referenced by @DependsOn annotation in " + description.getComponentClassName());
            }
            if (components.size() != 1) {
                throw new DeploymentUnitProcessingException("More than one EJB called" + annotationValue + " referenced by @DependsOn annotation in " + description.getComponentClassName() + " Components: " + components);
            }
            ComponentDescription component = (ComponentDescription)components.iterator().next();
            description.addDependency(component.getStartServiceName(), ServiceBuilder.DependencyType.REQUIRED);
            description.getDependsOn().add(component.getStartServiceName());
            if (!logger.isDebugEnabled()) continue;
            logger.debugf(description.getEJBName() + " bean is dependent on " + component.getComponentName(), new Object[0]);
        }
    }
}

