/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import javax.ejb.MessageDriven;
import javax.jms.MessageListener;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.metadata.MetadataCompleteMarker;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentMarker;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.ejb3.deployment.processors.EJBComponentDescriptionFactory;
import org.jboss.as.ejb3.deployment.processors.ViewInterfaces;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.spec.ActivationConfigMetaData;
import org.jboss.metadata.ejb.spec.ActivationConfigPropertiesMetaData;
import org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.MessageDrivenBeanMetaData;
import org.jboss.msc.service.ServiceName;

public class MessageDrivenComponentDescriptionFactory
extends EJBComponentDescriptionFactory {
    private static final Logger logger = Logger.getLogger(MessageDrivenComponentDescriptionFactory.class);
    private static final DotName MESSAGE_DRIVEN_ANNOTATION_NAME = DotName.createSimple((String)MessageDriven.class.getName());

    @Override
    protected void processAnnotations(DeploymentUnit deploymentUnit, CompositeIndex compositeIndex) throws DeploymentUnitProcessingException {
        if (MetadataCompleteMarker.isMetadataComplete((DeploymentUnit)deploymentUnit)) {
            return;
        }
        this.processMessageBeans(deploymentUnit, compositeIndex.getAnnotations(MESSAGE_DRIVEN_ANNOTATION_NAME));
    }

    @Override
    protected void processBeanMetaData(DeploymentUnit deploymentUnit, EnterpriseBeanMetaData enterpriseBeanMetaData) throws DeploymentUnitProcessingException {
        if (enterpriseBeanMetaData instanceof MessageDrivenBeanMetaData) {
            this.processMessageDrivenBeanMetaData(deploymentUnit, (MessageDrivenBeanMetaData)enterpriseBeanMetaData);
        }
    }

    private void processMessageBeans(DeploymentUnit deploymentUnit, Collection<AnnotationInstance> messageBeanAnnotations) throws DeploymentUnitProcessingException {
        if (messageBeanAnnotations.isEmpty()) {
            return;
        }
        EjbJarDescription ejbJarDescription = this.getEjbJarDescription(deploymentUnit);
        ServiceName deploymentUnitServiceName = deploymentUnit.getServiceName();
        for (AnnotationInstance messageBeanAnnotation : messageBeanAnnotations) {
            String messageListenerInterfaceName;
            String beanClassName;
            AnnotationTarget target = messageBeanAnnotation.target();
            ClassInfo beanClassInfo = (ClassInfo)target;
            if (!this.assertMDBClassValidity(beanClassInfo)) continue;
            String ejbName = beanClassInfo.name().local();
            AnnotationValue nameValue = messageBeanAnnotation.value("name");
            String beanName = nameValue == null || nameValue.asString().isEmpty() ? ejbName : nameValue.asString();
            MessageDrivenBeanMetaData beanMetaData = this.getEnterpriseBeanMetaData(deploymentUnit, beanName, MessageDrivenBeanMetaData.class);
            Properties activationConfigProperties = this.getActivationConfigProperties(messageBeanAnnotation);
            if (beanMetaData != null) {
                ActivationConfigPropertiesMetaData propertiesMetaData;
                beanClassName = MessageDrivenComponentDescriptionFactory.override(beanClassInfo.name().toString(), beanMetaData.getEjbClass());
                String messagingType = beanMetaData.getMessagingType();
                messageListenerInterfaceName = messagingType != null ? messagingType : this.getMessageListenerInterface(messageBeanAnnotation);
                ActivationConfigMetaData activationConfigMetaData = beanMetaData.getActivationConfig();
                if (activationConfigMetaData != null && (propertiesMetaData = activationConfigMetaData.getActivationConfigProperties()) != null) {
                    for (ActivationConfigPropertyMetaData propertyMetaData : propertiesMetaData) {
                        activationConfigProperties.put(propertyMetaData.getKey(), propertyMetaData.getValue());
                    }
                }
            } else {
                beanClassName = beanClassInfo.name().toString();
                messageListenerInterfaceName = this.getMessageListenerInterface(messageBeanAnnotation);
            }
            MessageDrivenComponentDescription beanDescription = new MessageDrivenComponentDescription(beanName, beanClassName, ejbJarDescription, deploymentUnitServiceName, messageListenerInterfaceName, activationConfigProperties);
            ejbJarDescription.getEEModuleDescription().addComponent((ComponentDescription)beanDescription);
        }
        EjbDeploymentMarker.mark(deploymentUnit);
    }

    private String getMessageListenerInterface(AnnotationInstance messageBeanAnnotation) throws DeploymentUnitProcessingException {
        AnnotationValue value = messageBeanAnnotation.value("messageListenerInterface");
        if (value != null) {
            return value.asClass().name().toString();
        }
        ClassInfo beanClass = (ClassInfo)messageBeanAnnotation.target();
        Set<DotName> interfaces = ViewInterfaces.getPotentialViewInterfaces(beanClass);
        if (interfaces.size() != 1) {
            throw new DeploymentUnitProcessingException("EJB 3.1 FR 5.4.2 MessageDrivenBean " + beanClass + " does not implement 1 interface nor specifies message listener interface");
        }
        return interfaces.iterator().next().toString();
    }

    private boolean assertMDBClassValidity(ClassInfo mdbClass) {
        short flags = mdbClass.flags();
        String className = mdbClass.name().toString();
        if (Modifier.isInterface(flags)) {
            logger.warn((Object)("[EJB3.1 spec, section 5.6.2] Message driven bean implementation class MUST NOT be a interface - " + className + " is an interface, hence won't be considered as a message driven bean"));
            return false;
        }
        if (!Modifier.isPublic(flags) || Modifier.isAbstract(flags) || Modifier.isFinal(flags)) {
            logger.warn((Object)("[EJB3.1 spec, section 5.6.2] Message driven bean implementation class MUST be public, not abstract and not final - " + className + " won't be considered as a message driven bean, since it doesn't meet that requirement"));
            return false;
        }
        return true;
    }

    private Properties getActivationConfigProperties(ActivationConfigMetaData activationConfig) {
        Properties activationConfigProps = new Properties();
        if (activationConfig == null || activationConfig.getActivationConfigProperties() == null) {
            return activationConfigProps;
        }
        ActivationConfigPropertiesMetaData activationConfigPropertiesMetaData = activationConfig.getActivationConfigProperties();
        for (ActivationConfigPropertyMetaData activationConfigProp : activationConfigPropertiesMetaData) {
            if (activationConfigProp == null) continue;
            String propName = activationConfigProp.getActivationConfigPropertyName();
            String propValue = activationConfigProp.getValue();
            if (propName == null) continue;
            activationConfigProps.put(propName, propValue);
        }
        return activationConfigProps;
    }

    private void processMessageDrivenBeanMetaData(DeploymentUnit deploymentUnit, MessageDrivenBeanMetaData mdb) throws DeploymentUnitProcessingException {
        EjbJarDescription ejbJarDescription = this.getEjbJarDescription(deploymentUnit);
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        String beanName = mdb.getName();
        if (ejbJarDescription.hasComponent(beanName)) {
            ComponentDescription description = eeModuleDescription.getComponentByName(beanName);
            if (!(description instanceof MessageDrivenComponentDescription)) {
                throw new DeploymentUnitProcessingException("MDB with name " + beanName + " referenced in ejb-jar.xml could not be created, as existing non MDB component with same name already exists: " + description);
            }
            ((MessageDrivenComponentDescription)description).setDescriptorData((EnterpriseBeanMetaData)mdb);
            return;
        }
        String beanClassName = mdb.getEjbClass();
        String messageListenerInterface = mdb.getMessagingType();
        if (messageListenerInterface == null || messageListenerInterface.trim().isEmpty()) {
            messageListenerInterface = MessageListener.class.getName();
        }
        Properties activationConfigProps = this.getActivationConfigProperties(mdb.getActivationConfig());
        MessageDrivenComponentDescription mdbComponentDescription = new MessageDrivenComponentDescription(beanName, beanClassName, ejbJarDescription, deploymentUnit.getServiceName(), messageListenerInterface, activationConfigProps);
        ejbJarDescription.getEEModuleDescription().addComponent((ComponentDescription)mdbComponentDescription);
        mdbComponentDescription.setDescriptorData((EnterpriseBeanMetaData)mdb);
    }

    private Properties getActivationConfigProperties(AnnotationInstance messageBeanAnnotation) {
        Properties props = new Properties();
        AnnotationValue activationConfig = messageBeanAnnotation.value("activationConfig");
        if (activationConfig == null) {
            return props;
        }
        for (AnnotationInstance propAnnotation : activationConfig.asNestedArray()) {
            props.put(propAnnotation.value("propertyName").asString(), propAnnotation.value("propertyValue").asString());
        }
        return props;
    }
}

