/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment;

import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.ejb3.tx.ApplicationExceptionDetails;

public class EjbJarConfiguration {
    private final Map<Class<?>, ApplicationExceptionDetails> applicationExceptions = new HashMap();

    public EjbJarConfiguration(EjbJarDescription deploymentDescription) {
    }

    public ApplicationExceptionDetails getApplicationException(Class<?> exceptionClass) {
        return this.applicationExceptions.get(exceptionClass);
    }

    public Map<Class<?>, ApplicationExceptionDetails> getApplicationExceptions() {
        return Collections.unmodifiableMap(this.applicationExceptions);
    }

    public void addApplicationException(Class<?> exceptionClass, ApplicationExceptionDetails applicationException) {
        if (exceptionClass == null) {
            throw new IllegalArgumentException("Exception class cannot be null");
        }
        if (applicationException == null) {
            throw new IllegalArgumentException("ApplicationException cannot be null");
        }
        if (!Exception.class.isAssignableFrom(exceptionClass)) {
            throw new IllegalArgumentException("[EJB 3.1 spec, section 14.1.1] Class: " + exceptionClass + " cannot be " + "marked as an application exception because it is not of type " + Exception.class.getName());
        }
        if (RemoteException.class.isAssignableFrom(exceptionClass)) {
            throw new IllegalArgumentException("[EJB 3.1 spec, section 14.1.1] Exception class: " + exceptionClass + " cannot be marked as an " + "application exception because it is of type " + RemoteException.class.getName());
        }
        this.applicationExceptions.put(exceptionClass, applicationException);
    }
}

