/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.context;

import org.jboss.as.ejb3.context.spi.InvocationContext;
import org.jboss.as.ejb3.context.util.ThreadLocalStack;

public class CurrentInvocationContext {
    private static final ThreadLocalStack<InvocationContext> stack = new ThreadLocalStack();

    public static InvocationContext get() {
        InvocationContext current = stack.get();
        if (current == null) {
            throw new IllegalStateException("No current invocation context available");
        }
        return current;
    }

    public static <T extends InvocationContext> T get(Class<T> expectedType) {
        return (T)((InvocationContext)expectedType.cast(CurrentInvocationContext.get()));
    }

    public static InvocationContext pop() {
        return stack.pop();
    }

    public static void push(InvocationContext invocation) {
        assert (invocation != null) : "invocation is null";
        stack.push(invocation);
    }
}

