/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagementType;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ee.component.BasicComponentCreateService;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.ComponentViewInstance;
import org.jboss.as.ejb3.component.EJBComponentCreateService;
import org.jboss.as.ejb3.component.EJBUtilities;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.MethodTransactionAttributeKey;
import org.jboss.as.ejb3.context.CurrentInvocationContext;
import org.jboss.as.ejb3.context.spi.InvocationContext;
import org.jboss.as.ejb3.security.EJBSecurityMetaData;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.as.ejb3.tx.ApplicationExceptionDetails;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.as.security.service.SimpleSecurityManager;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public abstract class EJBComponent
extends BasicComponent
implements org.jboss.as.ejb3.context.spi.EJBComponent {
    private static final Logger log = Logger.getLogger(EJBComponent.class);
    private static final ApplicationExceptionDetails APPLICATION_EXCEPTION = new ApplicationExceptionDetails("java.lang.Exception", true, false);
    private final Map<MethodTransactionAttributeKey, TransactionAttributeType> txAttrs;
    private final EJBUtilities utilities;
    private final boolean isBeanManagedTransaction;
    private final Map<Class<?>, ApplicationExceptionDetails> applicationExceptions;
    private final EJBSecurityMetaData securityMetaData;
    private final Map<String, ServiceName> viewServices;
    private final TimerService timerService;
    protected final Map<Method, InterceptorFactory> timeoutInterceptors;
    private final Method timeoutMethod;

    protected EJBComponent(EJBComponentCreateService ejbComponentCreateService) {
        super((BasicComponentCreateService)ejbComponentCreateService);
        this.applicationExceptions = Collections.unmodifiableMap(ejbComponentCreateService.getEjbJarConfiguration().getApplicationExceptions());
        this.utilities = ejbComponentCreateService.getEJBUtilities();
        Map<MethodTransactionAttributeKey, TransactionAttributeType> txAttrs = ejbComponentCreateService.getTxAttrs();
        this.txAttrs = txAttrs == null || txAttrs.isEmpty() ? Collections.emptyMap() : txAttrs;
        this.isBeanManagedTransaction = TransactionManagementType.BEAN.equals((Object)ejbComponentCreateService.getTransactionManagementType());
        this.securityMetaData = ejbComponentCreateService.getSecurityMetaData();
        this.viewServices = ejbComponentCreateService.getViewServices();
        this.timerService = ejbComponentCreateService.getTimerService();
        this.timeoutInterceptors = ejbComponentCreateService.getTimeoutInterceptors();
        this.timeoutMethod = ejbComponentCreateService.getTimeoutMethod();
    }

    protected <T> T createViewInstanceProxy(Class<T> viewInterface, Map<Object, Object> contextData) {
        if (viewInterface == null) {
            throw new IllegalArgumentException("View interface is null");
        }
        if (this.viewServices.containsKey(viewInterface.getName())) {
            ServiceController serviceController = CurrentServiceContainer.getServiceContainer().getRequiredService(this.viewServices.get(viewInterface.getName()));
            ComponentView view = (ComponentView)serviceController.getValue();
            ComponentViewInstance instance = view.createInstance(contextData);
            return viewInterface.cast(instance.createProxy());
        }
        throw new IllegalStateException("View of type " + viewInterface + " not found on bean " + this);
    }

    public ApplicationExceptionDetails getApplicationException(Class<?> exceptionClass, Method invokedMethod) {
        ApplicationExceptionDetails applicationException = this.applicationExceptions.get(exceptionClass);
        if (applicationException != null) {
            return applicationException;
        }
        for (Class<?> superClass = exceptionClass.getSuperclass(); superClass != null && !superClass.equals(Exception.class) && !superClass.equals(Object.class); superClass = superClass.getSuperclass()) {
            applicationException = this.applicationExceptions.get(superClass);
            if (applicationException == null) continue;
            if (applicationException.isInherited()) {
                return applicationException;
            }
            return null;
        }
        if (RuntimeException.class.isAssignableFrom(exceptionClass) || Error.class.isAssignableFrom(exceptionClass)) {
            return null;
        }
        if (invokedMethod != null) {
            Class<?>[] exceptionTypes;
            for (Class<?> type : exceptionTypes = invokedMethod.getExceptionTypes()) {
                if (!type.isAssignableFrom(exceptionClass)) continue;
                return APPLICATION_EXCEPTION;
            }
        }
        return null;
    }

    public Principal getCallerPrincipal() {
        return this.utilities.getSecurityManager().getCallerPrincipal();
    }

    protected TransactionAttributeType getCurrentTransactionAttribute() {
        InvocationContext currentInvocationContext = CurrentInvocationContext.get();
        if (currentInvocationContext == null) {
            return null;
        }
        Method invokedMethod = currentInvocationContext.getMethod();
        if (invokedMethod == null) {
            return null;
        }
        return this.getTransactionAttributeType(invokedMethod);
    }

    @Override
    public EJBHome getEJBHome() throws IllegalStateException {
        throw new RuntimeException("NYI: org.jboss.as.ejb3.component.EJBComponent.getEJBHome");
    }

    @Override
    public EJBLocalHome getEJBLocalHome() throws IllegalStateException {
        throw new RuntimeException("NYI: org.jboss.as.ejb3.component.EJBComponent.getEJBLocalHome");
    }

    @Override
    public boolean getRollbackOnly() throws IllegalStateException {
        if (this.isBeanManagedTransaction()) {
            throw new IllegalStateException("EJB 3.1 FR 13.6.1 Only beans with container-managed transaction demarcation can use getRollbackOnly.");
        }
        try {
            TransactionManager tm = this.getTransactionManager();
            if (tm.getTransaction() == null) {
                throw new IllegalStateException("getRollbackOnly() not allowed without a transaction.");
            }
            int status = tm.getStatus();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Current transaction status is " + status));
            }
            switch (status) {
                case 3: 
                case 4: {
                    throw new IllegalStateException("getRollbackOnly() not allowed after transaction is completed (EJBTHREE-1445)");
                }
                case 1: 
                case 9: {
                    return true;
                }
            }
            return false;
        }
        catch (SystemException se) {
            log.warn((Object)"failed to get tx manager status; ignoring", (Throwable)se);
            return true;
        }
    }

    public SimpleSecurityManager getSecurityManager() {
        return this.utilities.getSecurityManager();
    }

    @Override
    public TimerService getTimerService() throws IllegalStateException {
        return this.timerService;
    }

    @Deprecated
    public TransactionAttributeType getTransactionAttributeType(Method method) {
        return this.getTransactionAttributeType(MethodIntf.BEAN, method);
    }

    public TransactionAttributeType getTransactionAttributeType(MethodIntf methodIntf, Method method) {
        TransactionAttributeType txAttr = this.txAttrs.get(new MethodTransactionAttributeKey(methodIntf, MethodIdentifier.getIdentifierForMethod((Method)method)));
        if (txAttr == null) {
            return TransactionAttributeType.REQUIRED;
        }
        return txAttr;
    }

    public TransactionManager getTransactionManager() {
        return this.utilities.getTransactionManager();
    }

    public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return this.utilities.getTransactionSynchronizationRegistry();
    }

    public int getTransactionTimeout(Method method) {
        return -1;
    }

    @Override
    public UserTransaction getUserTransaction() throws IllegalStateException {
        if (!this.isBeanManagedTransaction()) {
            throw new IllegalStateException("EJB 3.1 FR 4.3.3 & 5.4.5 Only beans with bean-managed transaction demarcation can use this method.");
        }
        return this.utilities.getUserTransaction();
    }

    private boolean isBeanManagedTransaction() {
        return this.isBeanManagedTransaction;
    }

    public boolean isCallerInRole(String roleName) throws IllegalStateException {
        return this.utilities.getSecurityManager().isCallerInRole(new String[]{roleName});
    }

    @Override
    @Deprecated
    public boolean isCallerInRole(Principal callerPrincipal, String roleName) throws IllegalStateException {
        return this.isCallerInRole(roleName);
    }

    @Override
    public Object lookup(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("jndi name cannot be null during lookup");
        }
        NamespaceContextSelector namespaceContextSelector = NamespaceContextSelector.getCurrentSelector();
        if (namespaceContextSelector == null) {
            throw new IllegalStateException("No NamespaceContextSelector available, cannot lookup " + name);
        }
        Context jndiContext = null;
        String namespaceStrippedJndiName = name;
        if (name.startsWith("java:app/")) {
            jndiContext = namespaceContextSelector.getContext("app");
            namespaceStrippedJndiName = name.substring("java:app/".length());
        } else if (name.startsWith("java:module/")) {
            jndiContext = namespaceContextSelector.getContext("module");
            namespaceStrippedJndiName = name.substring("java:module/".length());
        } else if (name.startsWith("java:comp/")) {
            jndiContext = namespaceContextSelector.getContext("comp");
            namespaceStrippedJndiName = name.substring("java:comp/".length());
        } else if (!name.startsWith("java:")) {
            jndiContext = namespaceContextSelector.getContext("comp");
            namespaceStrippedJndiName = "env/" + name;
        } else if (name.startsWith("java:global/")) {
            try {
                jndiContext = new InitialContext();
            }
            catch (NamingException ne) {
                throw new RuntimeException("Could not lookup jndi name: " + name, ne);
            }
        } else {
            throw new IllegalArgumentException("Cannot lookup jndi name: " + name + " since it" + " doesn't belong to java:app, java:module, java:comp or java:global namespace");
        }
        log.debug((Object)("Looking up " + namespaceStrippedJndiName + " in jndi context: " + jndiContext));
        try {
            return jndiContext.lookup(namespaceStrippedJndiName);
        }
        catch (NamingException ne) {
            throw new IllegalArgumentException("Could not lookup jndi name: " + namespaceStrippedJndiName + " in context: " + jndiContext, ne);
        }
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException {
        if (this.isBeanManagedTransaction()) {
            throw new IllegalStateException("EJB 3.1 FR 13.6.1 Only beans with container-managed transaction demarcation can use setRollbackOnly.");
        }
        try {
            TransactionManager tm = this.getTransactionManager();
            if (tm.getTransaction() == null) {
                throw new IllegalStateException("setRollbackOnly() not allowed without a transaction.");
            }
            tm.setRollbackOnly();
        }
        catch (SystemException se) {
            log.warn((Object)"failed to set rollback only; ignoring", (Throwable)se);
        }
    }

    public EJBSecurityMetaData getSecurityMetaData() {
        return this.securityMetaData;
    }

    public TimedObjectInvoker getTimedObjectInvoker() {
        return null;
    }

    public Method getTimeoutMethod() {
        return this.timeoutMethod;
    }
}

