/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.ejb3.component.messagedriven.DefaultResourceAdapterService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

public class SetDefaultResourceAdapterName
implements OperationStepHandler {
    public static final SetDefaultResourceAdapterName INSTANCE = new SetDefaultResourceAdapterName();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String resourceAdapterName = operation.require("value").asString();
        ModelNode model = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel();
        model.get("default-resource-adapter-name").set(resourceAdapterName);
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep((OperationStepHandler)new DefaultResourceAdapterNameUpdateHandler(resourceAdapterName), OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }

    static class DefaultResourceAdapterNameUpdateHandler
    implements OperationStepHandler {
        private final String resourceAdapterName;

        DefaultResourceAdapterNameUpdateHandler(String resourceAdapterName) {
            this.resourceAdapterName = resourceAdapterName;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
            ServiceController existingDefaultRANameService = serviceRegistry.getService(DefaultResourceAdapterService.DEFAULT_RA_NAME_SERVICE_NAME);
            if (existingDefaultRANameService != null) {
                ((DefaultResourceAdapterService)existingDefaultRANameService.getValue()).setResourceAdapterName(this.resourceAdapterName);
            } else {
                DefaultResourceAdapterService defaultResourceAdapterService = new DefaultResourceAdapterService(this.resourceAdapterName);
                context.getServiceTarget().addService(DefaultResourceAdapterService.DEFAULT_RA_NAME_SERVICE_NAME, (Service)defaultResourceAdapterService).install();
            }
            context.completeStep();
        }
    }
}

