/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.dd;

import java.lang.reflect.Method;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.deployment.processors.dd.AbstractEjbXmlDescriptorProcessor;
import org.jboss.as.ejb3.deployment.processors.dd.MethodResolutionUtils;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.metadata.ejb.spec.RemoveMethodMetaData;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
import org.jboss.modules.Module;

public class RemoveMethodDeploymentDescriptorProcessor
extends AbstractEjbXmlDescriptorProcessor<SessionBeanMetaData> {
    @Override
    protected Class<SessionBeanMetaData> getMetaDataType() {
        return SessionBeanMetaData.class;
    }

    @Override
    protected void processBeanMetaData(SessionBeanMetaData beanMetaData, DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        Class componentClass;
        if (beanMetaData.getRemoveMethods() == null || beanMetaData.getRemoveMethods().isEmpty()) {
            return;
        }
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        StatefulComponentDescription sessionBean = (StatefulComponentDescription)moduleDescription.getComponentByName(beanMetaData.getEjbName());
        DeploymentReflectionIndex reflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.REFLECTION_INDEX);
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        if (module == null) {
            return;
        }
        if (sessionBean == null) {
            return;
        }
        try {
            componentClass = module.getClassLoader().loadClass(sessionBean.getComponentClassName());
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentUnitProcessingException("Could not load EJB class " + sessionBean.getComponentClassName());
        }
        for (RemoveMethodMetaData removeMethod : beanMetaData.getRemoveMethods()) {
            NamedMethodMetaData methodData = removeMethod.getBeanMethod();
            Method method = MethodResolutionUtils.resolveMethod(methodData, componentClass, reflectionIndex);
            sessionBean.addRemoveMethod(MethodIdentifier.getIdentifierForMethod((Method)method), removeMethod.isRetainIfException());
        }
    }
}

