/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ejb.StatefulTimeout;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.as.ejb3.deployment.processors.AbstractAnnotationEJBProcessor;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

public class StatefulTimeoutAnnotationProcessor
extends AbstractAnnotationEJBProcessor<StatefulComponentDescription> {
    private static final DotName TIMEOUT_ANNOTATION_DOT_NAME = DotName.createSimple((String)StatefulTimeout.class.getName());
    private static final Logger logger = Logger.getLogger(StatefulTimeoutAnnotationProcessor.class);

    @Override
    protected Class<StatefulComponentDescription> getComponentDescriptionType() {
        return StatefulComponentDescription.class;
    }

    @Override
    protected void processAnnotations(ClassInfo beanClass, CompositeIndex compositeIndex, StatefulComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        Map classAnnotations = beanClass.annotations();
        if (classAnnotations == null) {
            return;
        }
        List annotations = (List)classAnnotations.get(TIMEOUT_ANNOTATION_DOT_NAME);
        if (annotations == null) {
            return;
        }
        for (AnnotationInstance annotationInstance : annotations) {
            AnnotationTarget target = annotationInstance.target();
            long value = annotationInstance.value().asLong();
            AnnotationValue unitValue = annotationInstance.value("unit");
            TimeUnit unit = unitValue != null ? TimeUnit.valueOf(annotationInstance.value("unit").asEnum()) : TimeUnit.MINUTES;
            if (target instanceof ClassInfo) {
                componentDescription.setStatefulTimeout(new StatefulTimeoutInfo(value, unit));
                logger.debug((Object)("Bean " + componentDescription.getEJBName() + " marked for expiration using @StatefulTimeout " + target));
                continue;
            }
            logger.warn((Object)("@StatefulTime not placed on class in " + target));
        }
    }
}

