/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.List;
import java.util.Map;
import javax.annotation.security.RunAs;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.deployment.processors.AbstractAnnotationEJBProcessor;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

public class RunAsProcessor
extends AbstractAnnotationEJBProcessor<EJBComponentDescription> {
    private static final DotName RUN_AS_DOT_NAME = DotName.createSimple((String)RunAs.class.getName());
    private static final Logger logger = Logger.getLogger(RunAsProcessor.class);

    @Override
    protected Class<EJBComponentDescription> getComponentDescriptionType() {
        return EJBComponentDescription.class;
    }

    @Override
    protected void processAnnotations(ClassInfo beanClass, CompositeIndex index, EJBComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        Map annotationsOnBean = beanClass.annotations();
        if (annotationsOnBean == null || annotationsOnBean.isEmpty()) {
            return;
        }
        List runAsAnnotations = (List)annotationsOnBean.get(RUN_AS_DOT_NAME);
        if (runAsAnnotations == null || runAsAnnotations.isEmpty()) {
            return;
        }
        if (runAsAnnotations.size() > 1) {
            throw new DeploymentUnitProcessingException("More than one @RunAs annotation found on bean: " + componentDescription.getEJBName());
        }
        AnnotationInstance runAsAnnotation = (AnnotationInstance)runAsAnnotations.get(0);
        AnnotationValue annotationValue = runAsAnnotation.value();
        String runAsRole = annotationValue.asString();
        if (runAsRole != null && !runAsRole.trim().isEmpty()) {
            componentDescription.setRunAs(runAsRole);
            logger.debug((Object)(componentDescription.getEJBName() + " bean will use @RunAs role: " + runAsRole));
        }
    }
}

