/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import org.jboss.as.ejb3.EJBMethodIdentifier;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.deployment.processors.AbstractAnnotationEJBProcessor;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

public class RolesAllowedProcessor
extends AbstractAnnotationEJBProcessor<EJBComponentDescription> {
    private static final DotName ROLES_ALLOWED_DOT_NAME = DotName.createSimple((String)RolesAllowed.class.getName());

    @Override
    protected Class<EJBComponentDescription> getComponentDescriptionType() {
        return EJBComponentDescription.class;
    }

    @Override
    protected void processAnnotations(ClassInfo beanClass, CompositeIndex index, EJBComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        ClassInfo klass = beanClass;
        while (klass != null) {
            Map annotationsOnBean = klass.annotations();
            if (annotationsOnBean == null || annotationsOnBean.isEmpty()) {
                klass = this.getSuperClass(klass, index);
                continue;
            }
            List rolesAllowedAnnotations = (List)annotationsOnBean.get(ROLES_ALLOWED_DOT_NAME);
            if (rolesAllowedAnnotations == null || rolesAllowedAnnotations.isEmpty()) {
                klass = this.getSuperClass(klass, index);
                continue;
            }
            for (AnnotationInstance rolesAllowedAnnotation : rolesAllowedAnnotations) {
                AnnotationTarget target = rolesAllowedAnnotation.target();
                String[] roles = rolesAllowedAnnotation.value().asStringArray();
                if (target instanceof ClassInfo) {
                    String className = ((ClassInfo)target).name().toString();
                    componentDescription.setRolesAllowedOnAllViewsForClass(className, new HashSet<String>(Arrays.asList(roles)));
                    continue;
                }
                if (!(target instanceof MethodInfo)) continue;
                EJBMethodIdentifier ejbMethodIdentifier = EJBMethodIdentifier.fromMethodInfo((MethodInfo)target);
                componentDescription.setRolesAllowedOnAllViewsForMethod(ejbMethodIdentifier, new HashSet<String>(Arrays.asList(roles)));
            }
            klass = this.getSuperClass(klass, index);
        }
    }
}

