/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.dd;

import java.lang.reflect.Method;
import javax.interceptor.InvocationContext;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndexUtil;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.modules.Module;

public class DeploymentDescriptorMethodProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentReflectionIndex index = (DeploymentReflectionIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.REFLECTION_INDEX);
        EEApplicationClasses applicationClassesDescription = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        for (ComponentDescription component : eeModuleDescription.getComponentDescriptions()) {
            EJBComponentDescription ejb;
            if (!(component instanceof EJBComponentDescription) || (ejb = (EJBComponentDescription)component).getAroundInvokeDDMethods().isEmpty() && ejb.getPostConstructDDMethods().isEmpty() && ejb.getPreDestroyDDMethods().isEmpty()) continue;
            try {
                Method method;
                Class clazz = module.getClassLoader().loadClass(ejb.getComponentClassName());
                for (String aroundInvoke : ejb.getAroundInvokeDDMethods()) {
                    MethodIdentifier aroundInvokeIdentifier = MethodIdentifier.getIdentifier(Object.class, (String)aroundInvoke, (Class[])new Class[]{InvocationContext.class});
                    method = ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)index, (ClassReflectionIndex)index.getClassIndex(clazz), (MethodIdentifier)aroundInvokeIdentifier);
                    applicationClassesDescription.getOrAddClassByName(method.getDeclaringClass().getName()).setAroundInvokeMethod(aroundInvokeIdentifier);
                }
                for (String preDestroy : ejb.getPreDestroyDDMethods()) {
                    MethodIdentifier preDestroyIdentifier = MethodIdentifier.getIdentifier(Void.TYPE, (String)preDestroy, (Class[])new Class[0]);
                    method = ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)index, (ClassReflectionIndex)index.getClassIndex(clazz), (MethodIdentifier)preDestroyIdentifier);
                    applicationClassesDescription.getOrAddClassByName(method.getDeclaringClass().getName()).setPreDestroyMethod(preDestroyIdentifier);
                }
                for (String postConstruct : ejb.getPostConstructDDMethods()) {
                    MethodIdentifier postConstructIdentifier = MethodIdentifier.getIdentifier(Void.TYPE, (String)postConstruct, (Class[])new Class[0]);
                    method = ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)index, (ClassReflectionIndex)index.getClassIndex(clazz), (MethodIdentifier)postConstructIdentifier);
                    applicationClassesDescription.getOrAddClassByName(method.getDeclaringClass().getName()).setPostConstructMethod(postConstructIdentifier);
                }
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentUnitProcessingException("Could not load component class " + ejb.getComponentClassName());
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

