/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.Collection;
import java.util.Set;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.ViewBindingInjectionSource;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.logging.Logger;

public class EjbJndiBindingsDeploymentUnitProcessor
implements DeploymentUnitProcessor {
    private static final Logger logger = Logger.getLogger(EjbJndiBindingsDeploymentUnitProcessor.class);

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!EjbDeploymentMarker.isEjbDeployment(deploymentUnit)) {
            return;
        }
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        Collection componentDescriptions = eeModuleDescription.getComponentDescriptions();
        if (componentDescriptions == null || componentDescriptions.isEmpty()) {
            return;
        }
        for (ComponentDescription componentDescription : componentDescriptions) {
            if (!(componentDescription instanceof SessionBeanComponentDescription)) continue;
            this.setupJNDIBindings((SessionBeanComponentDescription)componentDescription, deploymentUnit);
        }
    }

    private void setupJNDIBindings(SessionBeanComponentDescription sessionBean, DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        Set views = sessionBean.getViews();
        if (views == null || views.isEmpty()) {
            logger.info((Object)("No jndi bindings will be created for EJB: " + sessionBean.getEJBName() + " since no views are exposed"));
            return;
        }
        String applicationName = this.getEarName(deploymentUnit);
        String globalJNDIBaseName = "java:global/" + (applicationName != null ? applicationName + "/" : "") + sessionBean.getModuleName() + "/" + sessionBean.getEJBName();
        String appJNDIBaseName = "java:app/" + sessionBean.getModuleName() + "/" + sessionBean.getEJBName();
        String moduleJNDIBaseName = "java:module/" + sessionBean.getEJBName();
        StringBuilder jndiBindingsLogMessage = new StringBuilder();
        jndiBindingsLogMessage.append("JNDI bindings for session bean named " + sessionBean.getEJBName() + " in deployment unit " + deploymentUnit + " are as follows:\n\n");
        EJBViewDescription ejbViewDescription = null;
        for (ViewDescription viewDescription : views) {
            ejbViewDescription = (EJBViewDescription)viewDescription;
            if (!ejbViewDescription.hasJNDIBindings()) continue;
            String viewClassName = ejbViewDescription.getViewClassName();
            String globalJNDIName = globalJNDIBaseName + "!" + viewClassName;
            this.registerBinding(viewDescription, globalJNDIName);
            this.logBinding(jndiBindingsLogMessage, globalJNDIName);
            String appJNDIName = appJNDIBaseName + "!" + viewClassName;
            this.registerBinding(viewDescription, appJNDIName);
            this.logBinding(jndiBindingsLogMessage, appJNDIName);
            String moduleJNDIName = moduleJNDIBaseName + "!" + viewClassName;
            this.registerBinding(viewDescription, moduleJNDIName);
            this.logBinding(jndiBindingsLogMessage, moduleJNDIName);
        }
        if (views.size() == 1) {
            EJBViewDescription viewDescription = (EJBViewDescription)((Object)views.iterator().next());
            if (ejbViewDescription.hasJNDIBindings()) {
                this.registerBinding(viewDescription, globalJNDIBaseName);
                this.logBinding(jndiBindingsLogMessage, globalJNDIBaseName);
                this.registerBinding(viewDescription, appJNDIBaseName);
                this.logBinding(jndiBindingsLogMessage, appJNDIBaseName);
                this.registerBinding(viewDescription, moduleJNDIBaseName);
                this.logBinding(jndiBindingsLogMessage, moduleJNDIBaseName);
            }
        }
        logger.info((Object)jndiBindingsLogMessage);
    }

    private void registerBinding(ViewDescription viewDescription, String jndiName) {
        ViewBindingInjectionSource moduleBindingSource = new ViewBindingInjectionSource(viewDescription.getServiceName());
        BindingConfiguration moduleBinding = new BindingConfiguration(jndiName, (InjectionSource)moduleBindingSource);
        this.addBindingConfiguration(viewDescription, moduleBinding);
    }

    private void logBinding(StringBuilder jndiBindingsLogMessage, String jndiName) {
        jndiBindingsLogMessage.append("\t");
        jndiBindingsLogMessage.append(jndiName);
        jndiBindingsLogMessage.append("\n");
    }

    private String getEarName(DeploymentUnit deploymentUnit) {
        DeploymentUnit parentDU = deploymentUnit.getParent();
        if (parentDU == null) {
            String duName = deploymentUnit.getName();
            if (duName.endsWith(".ear")) {
                return duName.substring(0, duName.length() - ".ear".length());
            }
            return null;
        }
        while (parentDU.getParent() != null) {
            parentDU = parentDU.getParent();
        }
        String duName = parentDU.getName();
        if (duName.endsWith(".ear")) {
            return duName.substring(0, duName.length() - ".ear".length());
        }
        return null;
    }

    private void addBindingConfiguration(ViewDescription viewDescription, final BindingConfiguration bindingConfiguration) {
        viewDescription.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.getBindingConfigurations().add(bindingConfiguration);
            }
        });
    }

    public void undeploy(DeploymentUnit context) {
    }
}

