/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.singleton;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.ejb.AccessTimeout;
import javax.ejb.LockType;
import org.jboss.as.ee.component.BasicComponentInstance;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ejb3.component.EJBBusinessMethod;
import org.jboss.as.ejb3.component.session.SessionBeanComponent;
import org.jboss.as.ejb3.component.singleton.SingletonComponentCreateService;
import org.jboss.as.ejb3.component.singleton.SingletonComponentInstance;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.server.CurrentServiceRegistry;
import org.jboss.ejb3.concurrency.spi.LockableComponent;
import org.jboss.invocation.Interceptor;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StopContext;

public class SingletonComponent
extends SessionBeanComponent
implements LockableComponent {
    private static final Logger logger = Logger.getLogger(SingletonComponent.class);
    private volatile SingletonComponentInstance singletonComponentInstance;
    private boolean initOnStartup;
    private Map<String, LockType> beanLevelLockType;
    private Map<EJBBusinessMethod, LockType> methodLockTypes;
    private Map<EJBBusinessMethod, AccessTimeout> methodAccessTimeouts;
    private final List<ServiceName> dependsOn;

    public SingletonComponent(SingletonComponentCreateService singletonComponentCreateService, List<ServiceName> dependsOn) {
        super(singletonComponentCreateService);
        this.dependsOn = dependsOn;
        this.initOnStartup = singletonComponentCreateService.isInitOnStartup();
        this.beanLevelLockType = singletonComponentCreateService.getBeanLockType();
        this.methodLockTypes = singletonComponentCreateService.getMethodApplicableLockTypes();
        this.methodAccessTimeouts = singletonComponentCreateService.getMethodApplicableAccessTimeouts();
    }

    protected BasicComponentInstance instantiateComponentInstance(AtomicReference<ManagedReference> instanceReference, Interceptor preDestroyInterceptor, Map<Method, Interceptor> methodInterceptors) {
        assert (Thread.holdsLock((Object)this));
        if (this.singletonComponentInstance != null) {
            return this.singletonComponentInstance;
        }
        if (this.dependsOn != null) {
            for (ServiceName serviceName : this.dependsOn) {
                ServiceController service = CurrentServiceRegistry.getServiceRegistry().getRequiredService(serviceName);
                Component component = (Component)service.getValue();
                if (!(component instanceof SingletonComponent)) continue;
                ((SingletonComponent)component).getComponentInstance();
            }
        }
        return new SingletonComponentInstance(this, instanceReference, preDestroyInterceptor, methodInterceptors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ComponentInstance getComponentInstance() {
        if (this.singletonComponentInstance == null) {
            SingletonComponent singletonComponent = this;
            synchronized (singletonComponent) {
                this.singletonComponentInstance = (SingletonComponentInstance)this.createInstance();
            }
        }
        return this.singletonComponentInstance;
    }

    public void start() {
        super.start();
        if (this.initOnStartup) {
            logger.debug((Object)(this.getComponentName() + " bean is a @Startup (a.k.a init-on-startup) bean, creating/getting the singleton instance"));
            this.getComponentInstance();
        }
    }

    public void stop(StopContext stopContext) {
        this.destroySingletonInstance();
        super.stop(stopContext);
    }

    public LockType getLockType(Method method) {
        EJBBusinessMethod ejbMethod = new EJBBusinessMethod(method);
        LockType lockType = this.methodLockTypes.get(ejbMethod);
        if (lockType != null) {
            return lockType;
        }
        LockType type = this.beanLevelLockType.get(method.getDeclaringClass().getName());
        if (type != null) {
            return type;
        }
        return LockType.WRITE;
    }

    public AccessTimeout getAccessTimeout(Method method) {
        EJBBusinessMethod ejbMethod = new EJBBusinessMethod(method);
        AccessTimeout accessTimeout = this.methodAccessTimeouts.get(ejbMethod);
        if (accessTimeout != null) {
            return accessTimeout;
        }
        AccessTimeout beanTimeout = (AccessTimeout)this.beanLevelAccessTimeout.get(method.getDeclaringClass().getName());
        if (beanTimeout != null) {
            return beanTimeout;
        }
        return new AccessTimeout(){

            public long value() {
                return 5L;
            }

            public TimeUnit unit() {
                return TimeUnit.MINUTES;
            }

            public Class<? extends Annotation> annotationType() {
                return AccessTimeout.class;
            }
        };
    }

    public AccessTimeout getDefaultAccessTimeout() {
        return new AccessTimeout(){

            public long value() {
                return 5L;
            }

            public TimeUnit unit() {
                return TimeUnit.MINUTES;
            }

            public Class<? extends Annotation> annotationType() {
                return AccessTimeout.class;
            }
        };
    }

    private synchronized void destroySingletonInstance() {
        if (this.singletonComponentInstance != null) {
            this.singletonComponentInstance.destroy();
            this.singletonComponentInstance = null;
        }
    }
}

