/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.ee.component.AbstractDeploymentDescriptorBindingsProcessor;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.EnvEntryInjectionSource;
import org.jboss.as.ee.component.LookupInjectionSource;
import org.jboss.as.ee.component.ResourceInjectionAnnotationParsingProcessor;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.javaee.spec.EnvironmentEntriesMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentEntryMetaData;
import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferenceMetaData;
import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferencesMetaData;
import org.jboss.metadata.javaee.spec.ResourceReferenceMetaData;
import org.jboss.metadata.javaee.spec.ResourceReferencesMetaData;
import org.jboss.metadata.javaee.support.ResourceInjectionMetaDataWithDescriptions;

public class ResourceReferenceProcessor
extends AbstractDeploymentDescriptorBindingsProcessor {
    @Override
    protected List<BindingConfiguration> processDescriptorEntries(DeploymentUnit deploymentUnit, DeploymentDescriptorEnvironment environment, EEModuleDescription moduleDescription, ComponentDescription componentDescription, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex, EEApplicationClasses applicationClasses) throws DeploymentUnitProcessingException {
        ArrayList<BindingConfiguration> bindings = new ArrayList<BindingConfiguration>();
        bindings.addAll(this.getEnvironmentEntries(environment, classLoader, deploymentReflectionIndex, moduleDescription, componentDescription, applicationClasses));
        bindings.addAll(this.getResourceEnvRefEntries(environment, classLoader, deploymentReflectionIndex, moduleDescription, componentDescription, applicationClasses));
        bindings.addAll(this.getResourceRefEntries(environment, classLoader, deploymentReflectionIndex, moduleDescription, componentDescription, applicationClasses));
        return bindings;
    }

    private List<BindingConfiguration> getResourceEnvRefEntries(DeploymentDescriptorEnvironment environment, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex, EEModuleDescription moduleDescription, ComponentDescription componentDescription, EEApplicationClasses applicationClasses) throws DeploymentUnitProcessingException {
        ArrayList<BindingConfiguration> bindings = new ArrayList<BindingConfiguration>();
        ResourceEnvironmentReferencesMetaData resourceEnvRefs = environment.getEnvironment().getResourceEnvironmentReferences();
        if (resourceEnvRefs == null) {
            return bindings;
        }
        for (ResourceEnvironmentReferenceMetaData resourceEnvRef : resourceEnvRefs) {
            String lookup;
            LookupInjectionSource injectionSource;
            String name = resourceEnvRef.getName().startsWith("java:") ? resourceEnvRef.getName() : environment.getDefaultContext() + resourceEnvRef.getName();
            Class<?> classType = null;
            if (resourceEnvRef.getType() != null) {
                try {
                    classType = classLoader.loadClass(resourceEnvRef.getType());
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentUnitProcessingException("Could not load " + resourceEnvRef.getType() + " referenced in env-entry ", (Throwable)e);
                }
            }
            if ((classType = this.processInjectionTargets(moduleDescription, applicationClasses, injectionSource = new LookupInjectionSource(name), classLoader, deploymentReflectionIndex, (ResourceInjectionMetaDataWithDescriptions)resourceEnvRef, classType)) == null) {
                throw new DeploymentUnitProcessingException("Could not determine type for resource-env-ref " + name);
            }
            BindingConfiguration bindingConfiguration = null;
            bindingConfiguration = !this.isEmpty(resourceEnvRef.getLookupName()) ? new BindingConfiguration(name, new LookupInjectionSource(resourceEnvRef.getLookupName())) : ((lookup = ResourceInjectionAnnotationParsingProcessor.FIXED_LOCATIONS.get(classType.getName())) != null ? new BindingConfiguration(name, new LookupInjectionSource(lookup)) : (resourceEnvRef.getResourceEnvRefName().startsWith("java:") ? new BindingConfiguration(name, new LookupInjectionSource(resourceEnvRef.getResourceEnvRefName())) : new BindingConfiguration(name, new LookupInjectionSource("java:/" + resourceEnvRef.getResourceEnvRefName()))));
            bindings.add(bindingConfiguration);
        }
        return bindings;
    }

    private List<BindingConfiguration> getResourceRefEntries(DeploymentDescriptorEnvironment environment, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex, EEModuleDescription moduleDescription, ComponentDescription componentDescription, EEApplicationClasses applicationClasses) throws DeploymentUnitProcessingException {
        ArrayList<BindingConfiguration> bindings = new ArrayList<BindingConfiguration>();
        ResourceReferencesMetaData resourceRefs = environment.getEnvironment().getResourceReferences();
        if (resourceRefs == null) {
            return bindings;
        }
        for (ResourceReferenceMetaData resourceRef : resourceRefs) {
            LookupInjectionSource injectionSource;
            String name = resourceRef.getName().startsWith("java:") ? resourceRef.getName() : environment.getDefaultContext() + resourceRef.getName();
            Class<?> classType = null;
            if (resourceRef.getType() != null) {
                try {
                    classType = classLoader.loadClass(resourceRef.getType());
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentUnitProcessingException("Could not load " + resourceRef.getType() + " referenced in env-entry ", (Throwable)e);
                }
            }
            if ((classType = this.processInjectionTargets(moduleDescription, applicationClasses, injectionSource = new LookupInjectionSource(name), classLoader, deploymentReflectionIndex, (ResourceInjectionMetaDataWithDescriptions)resourceRef, classType)) == null) {
                throw new DeploymentUnitProcessingException("Could not determine type for resource-ref " + name);
            }
            BindingConfiguration bindingConfiguration = null;
            bindingConfiguration = !this.isEmpty(resourceRef.getLookupName()) ? new BindingConfiguration(name, new LookupInjectionSource(resourceRef.getLookupName())) : (resourceRef.getResourceRefName().startsWith("java:") ? new BindingConfiguration(name, new LookupInjectionSource("java:jboss/resources/" + resourceRef.getResourceRefName())) : new BindingConfiguration(name, new LookupInjectionSource(resourceRef.getResourceRefName())));
            bindings.add(bindingConfiguration);
        }
        return bindings;
    }

    private List<BindingConfiguration> getEnvironmentEntries(DeploymentDescriptorEnvironment environment, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex, EEModuleDescription moduleDescription, ComponentDescription componentDescription, EEApplicationClasses applicationClasses) throws DeploymentUnitProcessingException {
        ArrayList<BindingConfiguration> bindings = new ArrayList<BindingConfiguration>();
        EnvironmentEntriesMetaData envEntries = environment.getEnvironment().getEnvironmentEntries();
        if (envEntries == null) {
            return bindings;
        }
        for (EnvironmentEntryMetaData envEntry : envEntries) {
            String name = envEntry.getName().startsWith("java:") ? envEntry.getName() : environment.getDefaultContext() + envEntry.getEnvEntryName();
            Class<?> classType = null;
            if (envEntry.getType() != null) {
                try {
                    classType = this.loadClass(envEntry.getType(), classLoader);
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentUnitProcessingException("Could not load " + envEntry.getType() + " referenced in env-entry ", (Throwable)e);
                }
            }
            String value = envEntry.getValue();
            String lookup = envEntry.getLookupName();
            if (!this.isEmpty(value) && !this.isEmpty(lookup)) {
                throw new DeploymentUnitProcessingException("Cannot specify both a <env-entry-value> and a <lookup-name> in an environemnt entry.");
            }
            if (this.isEmpty(lookup) && this.isEmpty(value)) continue;
            LookupInjectionSource injectionSource = new LookupInjectionSource(name);
            if ((classType = this.processInjectionTargets(moduleDescription, applicationClasses, injectionSource, classLoader, deploymentReflectionIndex, (ResourceInjectionMetaDataWithDescriptions)envEntry, classType)) == null) {
                throw new DeploymentUnitProcessingException("Could not determine type for <env-entry> " + name + " please specify the <env-entry-type>.");
            }
            String type = classType.getName();
            BindingConfiguration bindingConfiguration = null;
            if (!this.isEmpty(lookup)) {
                bindingConfiguration = new BindingConfiguration(name, new LookupInjectionSource(lookup));
            } else if (type.equals(String.class.getName())) {
                bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(value));
            } else if (type.equals(Integer.class.getName()) || type.equals("int")) {
                bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(Integer.valueOf(value)));
            } else if (type.equals(Short.class.getName()) || type.equals("short")) {
                bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(Short.valueOf(value)));
            } else if (type.equals(Long.class.getName()) || type.equals("long")) {
                bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(Long.valueOf(value)));
            } else if (type.equals(Byte.class.getName()) || type.equals("byte")) {
                bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(Byte.valueOf(value)));
            } else if (type.equals(Double.class.getName()) || type.equals("double")) {
                bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(Double.valueOf(value)));
            } else if (type.equals(Float.class.getName()) || type.equals("float")) {
                bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(Float.valueOf(value)));
            } else if (type.equals(Boolean.class.getName()) || type.equals("boolean")) {
                bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(Boolean.valueOf(value)));
            } else if (type.equals(Character.class.getName()) || type.equals("char")) {
                if (value.length() != 1) {
                    throw new DeploymentUnitProcessingException("env-entry of type java.lang.Character is not exactly one character long " + value);
                }
                bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(Character.valueOf(value.charAt(0))));
            } else if (type.equals(Class.class.getName())) {
                try {
                    bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(classLoader.loadClass(value)));
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentUnitProcessingException("Could not load class " + value + " specified in env-entry");
                }
            } else if (classType.isEnum() || classType.getEnclosingClass() != null && classType.getEnclosingClass().isEnum()) {
                bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(Enum.valueOf(classType, value)));
            } else {
                throw new DeploymentUnitProcessingException("Unkown env-entry type " + type);
            }
            bindings.add(bindingConfiguration);
        }
        return bindings;
    }

    private boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    @Override
    public void undeploy(DeploymentUnit context) {
    }

    private Class<?> loadClass(String className, ClassLoader cl) throws ClassNotFoundException {
        if (className == null || className.trim().isEmpty()) {
            throw new IllegalArgumentException("Classname cannot be null or empty: " + className);
        }
        if (className.equals(Void.TYPE.getName())) {
            return Void.TYPE;
        }
        if (className.equals(Byte.TYPE.getName())) {
            return Byte.TYPE;
        }
        if (className.equals(Short.TYPE.getName())) {
            return Short.TYPE;
        }
        if (className.equals(Integer.TYPE.getName())) {
            return Integer.TYPE;
        }
        if (className.equals(Long.TYPE.getName())) {
            return Long.TYPE;
        }
        if (className.equals(Character.TYPE.getName())) {
            return Character.TYPE;
        }
        if (className.equals(Boolean.TYPE.getName())) {
            return Boolean.TYPE;
        }
        if (className.equals(Float.TYPE.getName())) {
            return Float.TYPE;
        }
        if (className.equals(Double.TYPE.getName())) {
            return Double.TYPE;
        }
        return Class.forName(className, false, cl);
    }
}

