/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.as.ee.component.EEModuleClassDescription;

public final class EEApplicationClasses {
    private final ConcurrentMap<String, EEModuleClassDescription> classesByName = new ConcurrentHashMap<String, EEModuleClassDescription>();
    private final EEApplicationClasses parent;

    public EEApplicationClasses(EEApplicationClasses parent) {
        this.parent = parent;
    }

    public EEApplicationClasses() {
        this.parent = null;
    }

    public EEModuleClassDescription getClassByName(String name) {
        return (EEModuleClassDescription)this.classesByName.get(name);
    }

    public EEModuleClassDescription getOrAddClassByName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        EEModuleClassDescription description = (EEModuleClassDescription)this.classesByName.get(name);
        if (description == null && this.parent != null) {
            description = this.parent.getOrAddClassByName(name);
            this.classesByName.put(name, description);
        } else {
            description = new EEModuleClassDescription(name);
            EEModuleClassDescription existing = this.classesByName.putIfAbsent(name, description);
            if (existing != null) {
                return existing;
            }
        }
        return description;
    }

    public Collection<EEModuleClassDescription> getClassDescriptions() {
        return this.classesByName.values();
    }
}

