/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.services.net;

import java.net.InetAddress;
import org.jboss.as.model.socket.SocketBindingAdd;
import org.jboss.as.services.net.NetworkInterfaceBinding;
import org.jboss.as.services.net.NetworkInterfaceService;
import org.jboss.as.services.net.SocketBinding;
import org.jboss.as.services.net.SocketBindingManager;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class SocketBindingService
implements Service<SocketBinding> {
    private final String name;
    private final int port;
    private final boolean isFixedPort;
    private final InetAddress multicastAddress;
    private final int multicastPort;
    private SocketBinding binding;
    private final InjectedValue<NetworkInterfaceBinding> interfaceBinding = new InjectedValue();
    private final InjectedValue<SocketBindingManager> socketBindings = new InjectedValue();

    SocketBindingService(String name, int port, boolean isFixedPort, InetAddress multicastAddress, int multicastPort) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
        this.port = port;
        this.isFixedPort = isFixedPort;
        this.multicastAddress = multicastAddress;
        this.multicastPort = multicastPort;
    }

    public synchronized void start(StartContext context) throws StartException {
        this.binding = new SocketBinding(this.name, this.port, this.isFixedPort, this.multicastAddress, this.multicastPort, (NetworkInterfaceBinding)this.interfaceBinding.getValue(), (SocketBindingManager)this.socketBindings.getValue());
    }

    public synchronized void stop(StopContext context) {
        this.binding = null;
    }

    public synchronized SocketBinding getValue() throws IllegalStateException {
        SocketBinding binding = this.binding;
        if (binding == null) {
            throw new IllegalStateException();
        }
        return binding;
    }

    InjectedValue<SocketBindingManager> getSocketBindings() {
        return this.socketBindings;
    }

    InjectedValue<NetworkInterfaceBinding> getInterfaceBinding() {
        return this.interfaceBinding;
    }

    public static BatchServiceBuilder<SocketBinding> addService(BatchBuilder builder, SocketBindingAdd add) {
        SocketBindingService service = new SocketBindingService(add.getName(), add.getPort(), add.isFixedPort(), add.getMulticastAddress(), add.getMulticastPort());
        BatchServiceBuilder batch = builder.addService(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{add.getName()}), (Service)service);
        batch.addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{add.getInterfaceName()}), NetworkInterfaceBinding.class, service.getInterfaceBinding());
        batch.addDependency(SocketBindingManager.SOCKET_BINDING_MANAGER, SocketBindingManager.class, service.getSocketBindings());
        batch.setInitialMode(ServiceController.Mode.ON_DEMAND);
        return batch;
    }
}

