/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.services.net;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.jboss.as.model.socket.InterfaceCriteria;
import org.jboss.as.services.net.NetworkInterfaceBinding;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class NetworkInterfaceService
implements Service<NetworkInterfaceBinding> {
    public static final ServiceName JBOSS_NETWORK_INTERFACE = ServiceName.JBOSS.append(new String[]{"network"});
    private static final boolean preferIPv4Stack = Boolean.getBoolean("java.net.preferIPv4Stack");
    private static final boolean preferIPv6Stack = Boolean.getBoolean("java.net.preferIPv6Addresses");
    private static final String IPV4_ANYLOCAL = "0.0.0.0";
    private static final String IPV6_ANYLOCAL = "::";
    private NetworkInterfaceBinding interfaceBinding;
    private final String name;
    private final boolean anyLocalV4;
    private final boolean anyLocalV6;
    private final boolean anyLocal;
    private final InterfaceCriteria criteria;

    public NetworkInterfaceService(String name, boolean anyLocalV4, boolean anyLocalV6, boolean anyLocal, InterfaceCriteria criteria) {
        this.name = name;
        this.anyLocalV4 = anyLocalV4;
        this.anyLocalV6 = anyLocalV6;
        this.anyLocal = anyLocal;
        this.criteria = criteria;
    }

    public synchronized void start(StartContext arg0) throws StartException {
        try {
            this.interfaceBinding = this.anyLocalV4 ? NetworkInterfaceService.getNetworkInterfaceBinding(IPV4_ANYLOCAL) : (this.anyLocalV6 ? NetworkInterfaceService.getNetworkInterfaceBinding(IPV6_ANYLOCAL) : (this.anyLocal ? NetworkInterfaceService.getNetworkInterfaceBinding(preferIPv4Stack ? IPV4_ANYLOCAL : IPV6_ANYLOCAL) : NetworkInterfaceService.resolveInterface(this.criteria)));
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
        if (this.interfaceBinding == null) {
            throw new StartException("failed to resolve interface " + this.name);
        }
    }

    public synchronized void stop(StopContext arg0) {
        this.interfaceBinding = null;
    }

    public synchronized NetworkInterfaceBinding getValue() throws IllegalStateException {
        NetworkInterfaceBinding binding = this.interfaceBinding;
        if (binding == null) {
            throw new IllegalStateException();
        }
        return binding;
    }

    static NetworkInterfaceBinding resolveInterface(InterfaceCriteria criteria) throws SocketException {
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            Enumeration<InetAddress> interfaceAddresses = networkInterface.getInetAddresses();
            while (interfaceAddresses.hasMoreElements()) {
                InetAddress address = interfaceAddresses.nextElement();
                if (preferIPv4Stack && !preferIPv6Stack && !(address instanceof Inet4Address) || preferIPv6Stack && !preferIPv4Stack && !(address instanceof Inet6Address) || !criteria.isAcceptable(networkInterface, address)) continue;
                return new NetworkInterfaceBinding(Collections.singleton(networkInterface), address);
            }
        }
        return null;
    }

    static NetworkInterfaceBinding getNetworkInterfaceBinding(String addr) throws UnknownHostException, SocketException {
        InetAddress address = InetAddress.getByName(addr);
        ArrayList<NetworkInterface> interfaces = new ArrayList<NetworkInterface>();
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            interfaces.add(networkInterfaces.nextElement());
        }
        return new NetworkInterfaceBinding(interfaces, address);
    }
}

