/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model.socket;

import java.util.Collections;
import java.util.HashSet;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.as.model.Attribute;
import org.jboss.as.model.Element;
import org.jboss.as.model.socket.SocketBindingElement;
import org.jboss.as.model.socket.SocketBindingGroupIncludeElement;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class SocketBindingGroupElement
extends AbstractModelElement<SocketBindingGroupElement> {
    private static final long serialVersionUID = -7389975620327080290L;
    private final String name;
    private String defaultInterface;
    private final NavigableMap<String, SocketBindingGroupIncludeElement> includedGroups = new TreeMap<String, SocketBindingGroupIncludeElement>();
    private final NavigableMap<String, SocketBindingElement> socketBindings = new TreeMap<String, SocketBindingElement>();

    public SocketBindingGroupElement(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultInterface() {
        return this.defaultInterface;
    }

    void setDefaultInterface(String defaultInterface) {
        this.defaultInterface = defaultInterface;
    }

    public Set<String> getIncludedSocketBindingGroups() {
        return Collections.unmodifiableSet(new HashSet(this.includedGroups.keySet()));
    }

    public Set<SocketBindingElement> getSocketBindings() {
        return Collections.unmodifiableSet(new HashSet(this.socketBindings.values()));
    }

    @Override
    protected Class<SocketBindingGroupElement> getElementClass() {
        return SocketBindingGroupElement.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeAttribute(Attribute.NAME.getLocalName(), this.name);
        streamWriter.writeAttribute(Attribute.DEFAULT_INTERFACE.getLocalName(), this.defaultInterface);
        NavigableMap<String, AbstractModelElement> navigableMap = this.includedGroups;
        synchronized (navigableMap) {
            for (AbstractModelElement included : this.includedGroups.values()) {
                streamWriter.writeStartElement(Element.INCLUDE.getLocalName());
                ((SocketBindingGroupIncludeElement)included).writeContent(streamWriter);
            }
        }
        navigableMap = this.socketBindings;
        synchronized (navigableMap) {
            for (AbstractModelElement included : this.socketBindings.values()) {
                streamWriter.writeStartElement(Element.SOCKET_BINDING.getLocalName());
                ((SocketBindingElement)included).writeContent(streamWriter);
            }
        }
        streamWriter.writeEndElement();
    }

    void addIncludedGroup(String groupName) {
        this.includedGroups.put(groupName, new SocketBindingGroupIncludeElement(groupName));
    }

    boolean removeIncludedGroup(String groupName) {
        return this.includedGroups.remove(groupName) != null;
    }

    boolean addSocketBinding(String name, SocketBindingElement binding) {
        return this.socketBindings.put(name, binding) != null;
    }

    SocketBindingElement getSocketBinding(String name) {
        return (SocketBindingElement)this.socketBindings.get(name);
    }

    boolean removeSocketBinding(String name) {
        return this.socketBindings.remove(name) != null;
    }
}

