/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.AbstractSubsystemElement;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.ServerModel;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;

public final class ServerSubsystemUpdate<E extends AbstractSubsystemElement<E>, R>
extends AbstractServerModelUpdate<R> {
    private static final long serialVersionUID = -9127280126443066490L;
    private final AbstractSubsystemUpdate<E, R> subsystemUpdate;

    public ServerSubsystemUpdate(AbstractSubsystemUpdate<E, R> subsystemUpdate) {
        this.subsystemUpdate = subsystemUpdate;
    }

    public static <E extends AbstractSubsystemElement<E>, R> ServerSubsystemUpdate<E, R> create(AbstractSubsystemUpdate<E, R> subsystemUpdate) {
        return new ServerSubsystemUpdate<E, R>(subsystemUpdate);
    }

    @Override
    protected void applyUpdate(ServerModel element) throws UpdateFailedException {
        String namespaceUri = this.subsystemUpdate.getSubsystemNamespaceUri();
        AbstractSubsystemElement subsystemElement = (AbstractSubsystemElement)this.subsystemUpdate.getModelElementType().cast(element.getSubsystem(namespaceUri));
        if (subsystemElement == null) {
            throw new IllegalArgumentException("No such subsystem '" + namespaceUri + "' declared on server instance");
        }
        this.subsystemUpdate.applyUpdate(subsystemElement);
    }

    @Override
    public <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super R, P> handler, P param) {
        this.subsystemUpdate.applyUpdate(updateContext, handler, param);
    }

    @Override
    public ServerSubsystemUpdate<E, ?> getCompensatingUpdate(ServerModel original) {
        String namespaceUri = this.subsystemUpdate.getSubsystemNamespaceUri();
        AbstractSubsystemElement element = (AbstractSubsystemElement)this.subsystemUpdate.getModelElementType().cast(original.getSubsystem(namespaceUri));
        if (element == null) {
            throw new IllegalArgumentException("No such subsystem '" + namespaceUri + "' declared on server instance");
        }
        return ServerSubsystemUpdate.createUpdate(this.subsystemUpdate.getCompensatingUpdate(element));
    }

    private static <E extends AbstractSubsystemElement<E>, R> ServerSubsystemUpdate<E, R> createUpdate(AbstractSubsystemUpdate<E, R> update) {
        return new ServerSubsystemUpdate<E, R>(update);
    }
}

