/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.ManagementElement;
import org.jboss.as.model.ServerModel;
import org.jboss.as.model.UpdateFailedException;

public final class ServerModelManagementSocketThreadsUpdate
extends AbstractServerModelUpdate<Void> {
    private static final long serialVersionUID = 6075488950873140885L;
    private final int maxThreads;

    public ServerModelManagementSocketThreadsUpdate(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    @Override
    protected void applyUpdate(ServerModel element) throws UpdateFailedException {
        ManagementElement me = element.getManagementElement();
        if (me == null) {
            throw new UpdateFailedException("No management socket configured");
        }
        me.setMaxThreads(this.maxThreads);
    }

    public ServerModelManagementSocketThreadsUpdate getCompensatingUpdate(ServerModel original) {
        ManagementElement me = original.getManagementElement();
        if (me == null) {
            return null;
        }
        return new ServerModelManagementSocketThreadsUpdate(me.getMaxThreads());
    }
}

