/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import org.jboss.as.model.AbstractModelUpdate;
import org.jboss.as.model.AbstractPropertyUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.PropertiesElement;
import org.jboss.as.model.ServerGroupElement;
import org.jboss.as.model.ServerSystemPropertyUpdate;
import org.jboss.as.model.UpdateFailedException;

public class ServerGroupPropertiesUpdate
extends AbstractModelUpdate<ServerGroupElement, Void> {
    private static final long serialVersionUID = -466918965014839469L;
    private final String groupName;
    private final AbstractPropertyUpdate update;

    public ServerGroupPropertiesUpdate(String groupName, AbstractPropertyUpdate update) {
        this.groupName = groupName;
        this.update = update;
    }

    @Override
    protected void applyUpdate(ServerGroupElement element) throws UpdateFailedException {
        this.update.applyUpdate(element.getSystemProperties());
    }

    public ServerGroupPropertiesUpdate getCompensatingUpdate(ServerGroupElement element) {
        PropertiesElement original = element.getSystemProperties();
        return new ServerGroupPropertiesUpdate(this.groupName, this.update.getCompensatingUpdate(original));
    }

    @Override
    protected AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return new ServerSystemPropertyUpdate(this.update);
    }

    @Override
    public Class<ServerGroupElement> getModelElementType() {
        return ServerGroupElement.class;
    }
}

