/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.as.model.Attribute;
import org.jboss.as.model.Element;
import org.jboss.as.model.JvmElement;
import org.jboss.as.model.PropertiesElement;
import org.jboss.as.model.ServerGroupDeploymentElement;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public final class ServerGroupElement
extends AbstractModelElement<ServerGroupElement> {
    private static final long serialVersionUID = 3780369374145922407L;
    private final String name;
    private final String profile;
    private final Map<String, ServerGroupDeploymentElement> deploymentMappings = new LinkedHashMap<String, ServerGroupDeploymentElement>();
    private String bindingGroup;
    private int portOffset = 0;
    private JvmElement jvm;
    private final PropertiesElement systemProperties = new PropertiesElement(Element.PROPERTY, true);

    public ServerGroupElement(String name, String profile) {
        this.name = name;
        this.profile = profile;
    }

    public String getName() {
        return this.name;
    }

    public String getProfileName() {
        return this.profile;
    }

    public JvmElement getJvm() {
        return this.jvm;
    }

    void setJvm(JvmElement jvm) {
        this.jvm = jvm;
    }

    public String getSocketBindingGroupName() {
        return this.bindingGroup;
    }

    public int getSocketBindingPortOffset() {
        return this.portOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ServerGroupDeploymentElement> getDeployments() {
        LinkedHashSet<ServerGroupDeploymentElement> deps = new LinkedHashSet<ServerGroupDeploymentElement>();
        Map<String, ServerGroupDeploymentElement> map = this.deploymentMappings;
        synchronized (map) {
            for (Map.Entry<String, ServerGroupDeploymentElement> entry : this.deploymentMappings.entrySet()) {
                deps.add(entry.getValue());
            }
        }
        return deps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerGroupDeploymentElement getDeployment(String uniqueName) {
        Map<String, ServerGroupDeploymentElement> map = this.deploymentMappings;
        synchronized (map) {
            return this.deploymentMappings.get(uniqueName);
        }
    }

    public PropertiesElement getSystemProperties() {
        return this.systemProperties;
    }

    @Override
    protected Class<ServerGroupElement> getElementClass() {
        return ServerGroupElement.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeAttribute(Attribute.NAME.getLocalName(), this.name);
        streamWriter.writeAttribute(Attribute.PROFILE.getLocalName(), this.profile);
        if (this.jvm != null) {
            streamWriter.writeStartElement(Element.JVM.getLocalName());
            this.jvm.writeContent(streamWriter);
        }
        if (this.bindingGroup != null) {
            streamWriter.writeEmptyElement(Element.SOCKET_BINDING_GROUP.getLocalName());
            streamWriter.writeAttribute(Attribute.REF.getLocalName(), this.bindingGroup);
            if (this.portOffset != 0) {
                streamWriter.writeAttribute(Attribute.PORT_OFFSET.getLocalName(), String.valueOf(this.portOffset));
            }
        }
        Map<String, ServerGroupDeploymentElement> map = this.deploymentMappings;
        synchronized (map) {
            if (!this.deploymentMappings.isEmpty()) {
                streamWriter.writeStartElement(Element.DEPLOYMENTS.getLocalName());
                for (ServerGroupDeploymentElement element : this.deploymentMappings.values()) {
                    streamWriter.writeStartElement(Element.DEPLOYMENT.getLocalName());
                    element.writeContent(streamWriter);
                }
                streamWriter.writeEndElement();
            }
        }
        if (this.systemProperties != null && this.systemProperties.size() > 0) {
            streamWriter.writeStartElement(Element.SYSTEM_PROPERTIES.getLocalName());
            this.systemProperties.writeContent(streamWriter);
        }
        streamWriter.writeEndElement();
    }

    boolean addJvm(String jvmName) {
        if (this.jvm != null) {
            return false;
        }
        this.jvm = new JvmElement(jvmName);
        return true;
    }

    void removeJvm() {
        this.jvm = null;
    }

    void setSocketBindingGroupName(String name) {
        this.bindingGroup = name;
    }

    void setSocketBindingPortOffset(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset " + offset + " is less than zero");
        }
        this.portOffset = offset;
    }

    boolean addDeployment(String uniqueName, String runtimeName, byte[] hash, boolean start) {
        if (this.deploymentMappings.containsKey(uniqueName)) {
            return false;
        }
        this.deploymentMappings.put(uniqueName, new ServerGroupDeploymentElement(uniqueName, runtimeName, hash, start));
        return true;
    }

    boolean removeDeployment(String uniqueName) {
        return this.deploymentMappings.remove(uniqueName) != null;
    }
}

