/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import org.jboss.as.model.AbstractModelUpdate;
import org.jboss.as.model.ServerGroupDeploymentElement;
import org.jboss.as.model.ServerGroupElement;
import org.jboss.as.model.ServerModelDeploymentStartStopUpdate;
import org.jboss.as.model.UpdateFailedException;

public class ServerGroupDeploymentStartStopUpdate
extends AbstractModelUpdate<ServerGroupElement, Void> {
    private static final long serialVersionUID = 5773083013951607950L;
    private final String deploymentUnitName;
    private final boolean isStart;

    public ServerGroupDeploymentStartStopUpdate(String deploymentUnitName, boolean isStart) {
        if (deploymentUnitName == null) {
            throw new IllegalArgumentException("deploymentUnitName is null");
        }
        this.deploymentUnitName = deploymentUnitName;
        this.isStart = isStart;
    }

    public String getDeploymentUnitName() {
        return this.deploymentUnitName;
    }

    public boolean isStart() {
        return this.isStart;
    }

    public ServerGroupDeploymentStartStopUpdate getCompensatingUpdate(ServerGroupElement original) {
        return new ServerGroupDeploymentStartStopUpdate(this.deploymentUnitName, !this.isStart);
    }

    protected ServerModelDeploymentStartStopUpdate getServerModelUpdate() {
        return new ServerModelDeploymentStartStopUpdate(this.deploymentUnitName, this.isStart);
    }

    @Override
    protected void applyUpdate(ServerGroupElement serverGroupElement) throws UpdateFailedException {
        ServerGroupDeploymentElement deploymentElement = serverGroupElement.getDeployment(this.deploymentUnitName);
        if (deploymentElement == null) {
            throw new UpdateFailedException(String.format("Deployment %s does not exist in server group %s", deploymentElement, serverGroupElement.getName()));
        }
        deploymentElement.setStart(this.isStart);
    }

    @Override
    public Class<ServerGroupElement> getModelElementType() {
        return ServerGroupElement.class;
    }
}

